/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.stacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.rap.internal.design.example.Messages;
import org.eclipse.rap.internal.design.example.builder.DummyBuilder;
import org.eclipse.rap.internal.design.example.managers.ItemData;
import org.eclipse.rap.internal.design.example.managers.ViewToolBarManager;
import org.eclipse.rap.internal.design.example.stacks.ConfigAction;
import org.eclipse.rap.ui.interactiondesign.ConfigurableStack;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class ConfigurationDialog
extends PopupDialog {
    private static final int OFFSET = 3;
    private final IStackPresentationSite site;
    private final ConfigAction action;
    private final HashMap actionButtonMap = new HashMap();
    private final List actionList = new ArrayList();
    private final ElementBuilder builder;
    private Button viewMenuBox;
    private boolean viewMenuVisChanged;
    private Label lastImageLabel;
    private Label description;

    public ConfigurationDialog(Shell parent, int shellStyle, IStackPresentationSite site, ConfigAction action) {
        super(parent, shellStyle, true, false, false, false, false, null, null);
        this.site = site;
        this.action = action;
        this.builder = new DummyBuilder((Composite)parent, "org.eclipse.rap.design.example.layoutset.confdialog");
        this.viewMenuVisChanged = false;
    }

    protected void adjustBounds() {
        this.getShell().layout();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Rectangle bounds = window.getShell().getBounds();
        int newWidth = this.getShell().getBounds().width + 20;
        int newHeight = this.getShell().getBounds().height + 20;
        this.getShell().setBounds(bounds.x + bounds.width / 2 - newWidth / 2, bounds.y + bounds.height / 2 - newHeight / 2, newWidth, newHeight);
    }

    public boolean close(boolean save) {
        if (save) {
            this.saveViewMenuVisibility();
            this.saveViewActionVisibilities();
        }
        return this.close();
    }

    public boolean close() {
        ConfigurableStack stackPresentation = (ConfigurableStack)this.action.getStackPresentation();
        IToolBarManager manager = stackPresentation.getPartToolBarManager();
        if (manager != null) {
            manager.update(true);
        }
        this.action.fireToolBarChange();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite background = new Composite(parent, 0);
        background.setLayout((Layout)new FormLayout());
        Color white = this.builder.getColor("CONFIG_WHITE");
        Composite configComposite = new Composite(background, 0);
        FormData fdConfigComposite = new FormData();
        fdConfigComposite.top = new FormAttachment(0, 0);
        fdConfigComposite.left = new FormAttachment(0, 10);
        fdConfigComposite.right = new FormAttachment(100, -10);
        fdConfigComposite.bottom = new FormAttachment(100, -10);
        configComposite.setLayoutData((Object)fdConfigComposite);
        configComposite.setLayout((Layout)new FormLayout());
        this.loadActionSettings(configComposite);
        this.hookViewMenuArea(white, configComposite);
        Button cancel = new Button(configComposite, 8);
        cancel.setText(Messages.get().ConfigurationDialog_Cancel);
        FormData fdCancel = new FormData();
        cancel.setLayoutData((Object)fdCancel);
        fdCancel.bottom = new FormAttachment(100, 0);
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.width = 90;
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.close(false);
            }
        });
        Button ok = new Button(configComposite, 8);
        ok.setText(Messages.get().ConfigurationDialog_Ok);
        FormData fdOK = new FormData();
        ok.setLayoutData((Object)fdOK);
        fdOK.right = new FormAttachment((Control)cancel, -3);
        fdOK.bottom = fdCancel.bottom;
        fdOK.width = 90;
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.close(true);
            }
        });
        ok.moveAbove((Control)cancel);
        return background;
    }

    private void hookViewMenuArea(Color white, Composite configComposite) {
        if (this.action.hasPartMenu()) {
            this.viewMenuBox = new Button(configComposite, 32);
            this.viewMenuBox.setForeground(white);
            this.viewMenuBox.setSelection(this.action.isPartMenuVisible());
            this.viewMenuVisChanged = this.viewMenuBox.getSelection();
            FormData fdViewMenuBox = new FormData();
            this.viewMenuBox.setLayoutData((Object)fdViewMenuBox);
            this.viewMenuBox.setData("org.eclipse.rap.rwt.customVariant", (Object)"configMenuButton");
            if (this.lastImageLabel != null) {
                fdViewMenuBox.top = new FormAttachment((Control)this.lastImageLabel, 3);
                fdViewMenuBox.left = new FormAttachment((Control)this.lastImageLabel, 8);
            } else {
                fdViewMenuBox.top = new FormAttachment((Control)this.description, 3);
                fdViewMenuBox.left = new FormAttachment(0, 8);
            }
            this.viewMenuBox.setText(Messages.get().ConfigurationDialog_ViewMenu);
        }
    }

    private void loadActionSettings(Composite container) {
        ConfigurableStack stackPresentation = (ConfigurableStack)this.action.getStackPresentation();
        IToolBarManager manager = stackPresentation.getPartToolBarManager();
        this.description = null;
        this.description = new Label(container, 0);
        this.description.setText(Messages.get().ConfigurationDialog_VisibleActions);
        FormData fdActionDesc = new FormData();
        this.description.setLayoutData((Object)fdActionDesc);
        fdActionDesc.top = this.viewMenuBox != null ? new FormAttachment((Control)this.viewMenuBox, 3) : new FormAttachment(0, 3);
        fdActionDesc.left = new FormAttachment(0, 3);
        if (manager != null) {
            String paneId = stackPresentation.getPaneId(this.site);
            if (manager instanceof ViewToolBarManager) {
                ItemData[] itemsData = ((ViewToolBarManager)manager).getItemsData();
                int i = 0;
                while (i < itemsData.length) {
                    ItemData itemData = itemsData[i];
                    String itemId = itemData.getId();
                    Image icon = itemData.getImage();
                    String text = "";
                    text = itemData.getText() != null && !itemData.getText().equals("") ? itemData.getText() : itemData.getToolTipText();
                    Label imageLabel = new Label(container, 0);
                    imageLabel.setImage(icon);
                    FormData fdImageLabel = new FormData();
                    imageLabel.setLayoutData((Object)fdImageLabel);
                    if (this.lastImageLabel != null) {
                        fdImageLabel.top = new FormAttachment((Control)this.lastImageLabel, 3);
                        this.lastImageLabel = imageLabel;
                    } else {
                        fdImageLabel.top = new FormAttachment((Control)this.description, 3);
                        this.lastImageLabel = imageLabel;
                    }
                    fdImageLabel.left = new FormAttachment(0, 12);
                    Button check = new Button(container, 32);
                    check.setText(text);
                    check.setLayoutData((Object)new GridData(768));
                    boolean selected = this.action.isViewActionVisibile(paneId, itemId);
                    FormData fdCheck = new FormData();
                    check.setLayoutData((Object)fdCheck);
                    fdCheck.left = new FormAttachment((Control)imageLabel, 8);
                    fdCheck.top = fdImageLabel.top;
                    check.setSelection(selected);
                    check.setData("org.eclipse.rap.rwt.customVariant", (Object)"configMenuButton");
                    this.actionButtonMap.put(itemId, check);
                    this.actionList.add(itemId);
                    this.lastImageLabel = imageLabel;
                    ++i;
                }
            }
        }
    }

    public int open() {
        int result = super.open();
        Shell shell = this.getShell();
        shell.setData("org.eclipse.rap.rwt.customVariant", (Object)"confDialog");
        shell.setBackgroundMode(0);
        shell.setText(String.valueOf(Messages.get().ConfigurationDialog_ConfigurationFor) + this.site.getSelectedPart().getName());
        String configDialogIcon = "dialog.conf.icon";
        shell.setImage(this.builder.getImage(configDialogIcon));
        shell.setActive();
        shell.setFocus();
        this.action.fireToolBarChange();
        this.adjustBounds();
        return result;
    }

    private void saveViewActionVisibilities() {
        ConfigurableStack stackPresentation = (ConfigurableStack)this.action.getStackPresentation();
        String paneId = stackPresentation.getPaneId(this.site);
        int i = 0;
        while (i < this.actionList.size()) {
            String actionId = (String)this.actionList.get(i);
            Button check = (Button)this.actionButtonMap.get(actionId);
            this.action.saveViewActionVisibility(paneId, actionId, check.getSelection());
            ++i;
        }
    }

    private void saveViewMenuVisibility() {
        boolean selection;
        if (this.viewMenuBox != null && (selection = this.viewMenuBox.getSelection()) != this.viewMenuVisChanged) {
            this.action.savePartMenuVisibility(selection);
        }
    }
}

