/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class RenameElementCommand
extends RecordingCommand {
    private final TransactionalEditingDomain domain;
    private final NamedElement element;
    private final String name;

    public RenameElementCommand(TransactionalEditingDomain domain, NamedElement namedElement, String name) {
        super(domain);
        this.domain = domain;
        this.element = namedElement;
        this.name = name;
    }

    protected void doExecute() {
        ICommand rename = null;
        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((EObject)this.element);
        if (edit != null) {
            rename = edit.getEditCommand((IEditCommandRequest)new SetRequest(this.domain, (EObject)this.element, (EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__NAME, (Object)this.name));
        }
        try {
            if (rename != null && rename.canExecute()) {
                try {
                    rename.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    this.element.setName(this.name);
                    Activator.log.error((Throwable)e);
                }
            } else {
                this.element.setName(this.name);
            }
        }
        finally {
            if (rename != null) {
                rename.dispose();
            }
        }
    }
}

