/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSFontStyle;
import org.w3c.dom.css.CSSValue;

public class CSSFontStyleDelegate
implements CSSFontStyle {
    private FontStyle fontStyle;
    private ExtendedCSSEngine engine;

    public CSSFontStyleDelegate(FontStyle fontStyle, ExtendedCSSEngine engine) {
        this.fontStyle = fontStyle;
        this.engine = engine;
    }

    @Override
    public int getCSSFontColor() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fontStyle, "fontColor");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_FontColor().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, "GMFColor", null);
    }

    @Override
    public String getCSSFontName() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fontStyle, "fontName");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_FontName().getDefaultValue();
            return (String)defaultValue;
        }
        return (String)this.engine.convert(cssValue, String.class, null);
    }

    @Override
    public int getCSSFontHeight() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fontStyle, "fontHeight");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_FontHeight().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    @Override
    public boolean isCSSBold() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fontStyle, "bold");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_Bold().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    @Override
    public boolean isCSSItalic() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fontStyle, "italic");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_Italic().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    @Override
    public boolean isCSSUnderline() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fontStyle, "underline");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_Underline().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    @Override
    public boolean isCSSStrikeThrough() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.fontStyle, "strikeThrough");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }
}

