/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql.contentAssist;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ContentAssistElement;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.SuggestionProvider;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.graphics.Image;

public class FieldsSuggestionProvider
implements SuggestionProvider {
    private static final String CLASS_SEP = " - ";
    boolean ready = false;
    private TreeSet<ContentAssistElement> orderedList;

    public FieldsSuggestionProvider(ISnapshot snapshot) {
    }

    public void setClassesSuggestions(ISnapshot snapshot, IContextInformation[] classSuggestions) {
        this.ready = false;
        try {
            this.initList(snapshot, classSuggestions);
        }
        catch (SnapshotException e) {
            ErrorHelper.logThrowable(e);
        }
    }

    @Override
    public List<ContentAssistElement> getSuggestions(String context) {
        LinkedList<ContentAssistElement> tempList = new LinkedList<ContentAssistElement>();
        boolean foundFirst = false;
        if (this.ready) {
            for (ContentAssistElement cp : this.orderedList) {
                String cName = cp.getClassName();
                if (cName.startsWith(context)) {
                    foundFirst = true;
                    tempList.add(cp);
                    continue;
                }
                if (foundFirst) break;
            }
        }
        return tempList;
    }

    private void initList(ISnapshot snapshot, IContextInformation[] classSuggestions) throws SnapshotException {
        if (snapshot == null) {
            throw new IllegalArgumentException("Cannot extract class list from a null snapshot.");
        }
        this.ready = false;
        HashSet classes = new HashSet();
        IContextInformation[] iContextInformationArray = classSuggestions;
        int n = classSuggestions.length;
        int n2 = 0;
        while (n2 < n) {
            IContextInformation el = iContextInformationArray[n2];
            Collection cls = snapshot.getClassesByName(el.getContextDisplayString(), false);
            if (cls != null) {
                classes.addAll(cls);
            }
            ++n2;
        }
        this.orderedList = new TreeSet();
        Image im = MemoryAnalyserPlugin.getImage("$nl$/icons/heapobjects/class.gif");
        for (IClass c : classes) {
            do {
                for (FieldDescriptor fd : c.getFieldDescriptors()) {
                    String desc = String.valueOf(fd.getVerboseSignature()) + " " + fd.getName() + CLASS_SEP + c.getName();
                    ContentAssistElement ce = new ContentAssistElement(fd.getName(), im, desc);
                    if (this.orderedList.contains(ce)) continue;
                    this.orderedList.add(ce);
                }
            } while ((c = c.getSuperClass()) != null);
        }
        this.ready = true;
    }

    private class InitializerJob
    extends Job {
        ISnapshot snapshot;
        IContextInformation[] classSuggestions;

        public InitializerJob(ISnapshot snapshot, IContextInformation[] suggestions) {
            super("Init content assistant");
            this.snapshot = snapshot;
            this.classSuggestions = suggestions;
        }

        protected IStatus run(IProgressMonitor arg0) {
            try {
                FieldsSuggestionProvider.this.initList(this.snapshot, this.classSuggestions);
                return Status.OK_STATUS;
            }
            catch (SnapshotException e) {
                ErrorHelper.logThrowable(e);
                return Status.CANCEL_STATUS;
            }
        }
    }
}

