/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies;

import java.util.List;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.CreateDiagramLinkCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramLinkDragDropEditPolicy
extends DragDropEditPolicy {
    @Override
    public Command getDropObjectsCommand(DropObjectsRequest request) {
        if ("drop_objects".equals(request.getType())) {
            DropObjectsRequest elements = request;
            for (Object element : elements.getObjects()) {
                if (!(element instanceof Diagram)) continue;
                Diagram diagram = (Diagram)element;
                View view = (View)this.getHost().getModel();
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                CreateDiagramLinkCommand com = new CreateDiagramLinkCommand(editingDomain, DiagramUIMessages.Command_CreateDiagramLink, view, diagram);
                return new ICommandProxy((ICommand)com);
            }
        }
        return null;
    }

    @Override
    public boolean understandsRequest(Request request) {
        if ("drop_objects".equals(request.getType())) {
            List elements = ((DropObjectsRequest)request).getObjects();
            return elements.size() == 1 && elements.get(0) instanceof Diagram;
        }
        return super.understandsRequest(request);
    }

    @Override
    public void showTargetFeedback(Request request) {
        if (this.understandsRequest(request)) {
            super.showTargetFeedback(request);
        }
    }

    @Override
    protected int getRequiredDragDetail(Request request) {
        if (request instanceof DropObjectsRequest) {
            DropObjectsRequest req = (DropObjectsRequest)request;
            if ((req.getAllowedDetail() & 4) != 0) {
                return 4;
            }
            return 1;
        }
        return super.getRequiredDragDetail(request);
    }
}

