/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.ext.widgets.reference.internal;

import java.util.Collection;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EEFExtReferenceDescription;
import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EefExtWidgetsReferencePackage;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManagerProvider;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.AbstractEEFExtReferenceLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtMultipleReferenceLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtSingleReferenceLifecycleManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFExtReferenceLifecycleManagerProvider
implements IEEFLifecycleManagerProvider {
    public boolean canHandle(EEFControlDescription controlDescription) {
        return controlDescription != null && controlDescription.eClass() == EefExtWidgetsReferencePackage.Literals.EEF_EXT_REFERENCE_DESCRIPTION;
    }

    public IEEFLifecycleManager getLifecycleManager(EEFControlDescription controlDescription, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        EStructuralFeature eStructuralFeature;
        if (!(controlDescription instanceof EEFExtReferenceDescription) || Util.isBlank((String)((EEFExtReferenceDescription)controlDescription).getReferenceNameExpression())) {
            return null;
        }
        AbstractEEFExtReferenceLifecycleManager lifecycleManager = null;
        EEFExtReferenceDescription description = (EEFExtReferenceDescription)controlDescription;
        EObject target = this.getTarget(description, interpreter, variableManager);
        String referenceName = this.getReferenceName(description, interpreter, variableManager);
        if (target != null && !Util.isBlank((String)referenceName) && (eStructuralFeature = target.eClass().getEStructuralFeature(referenceName)) instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            lifecycleManager = eReference.isMany() ? new EEFExtMultipleReferenceLifecycleManager(description, target, eReference, variableManager, interpreter, contextAdapter) : new EEFExtSingleReferenceLifecycleManager(description, target, eReference, variableManager, interpreter, contextAdapter);
        }
        return lifecycleManager;
    }

    private EObject getTarget(EEFExtReferenceDescription description, IInterpreter interpreter, IVariableManager variableManager) {
        EObject self = null;
        if (!Util.isBlank((String)description.getReferenceOwnerExpression())) {
            Collection eObjects;
            IEvaluationResult result = interpreter.evaluateExpression(variableManager.getVariables(), description.getReferenceOwnerExpression());
            if (result.success() && (eObjects = result.asEObjects()).size() > 0) {
                self = (EObject)eObjects.iterator().next();
            }
        } else {
            Object selfVariable = variableManager.getVariables().get("self");
            if (selfVariable instanceof EObject) {
                self = (EObject)selfVariable;
            }
        }
        return self;
    }

    private String getReferenceName(EEFExtReferenceDescription description, IInterpreter interpreter, IVariableManager variableManager) {
        IEvaluationResult evaluationResult = interpreter.evaluateExpression(variableManager.getVariables(), description.getReferenceNameExpression());
        if (evaluationResult.success()) {
            return evaluationResult.asString();
        }
        return "";
    }
}

