/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.internal.zseries;

import java.net.ConnectException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.drivers.jdbc.JDBCConnection;
import org.eclipse.datatools.connectivity.exceptions.DBNotStartException;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;

public class JDBCZSeriesJDBCConnection
extends JDBCConnection {
    private Version techVersion = Version.NULL_VERSION;
    private Version serverVersion = Version.NULL_VERSION;
    private String serverName;

    public JDBCZSeriesJDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    public String getProviderName() {
        return this.serverName;
    }

    public Version getProviderVersion() {
        return this.serverVersion;
    }

    public Version getTechnologyVersion() {
        return this.techVersion;
    }

    protected void initVersions() {
        try {
            DatabaseMetaData dbmd = ((Connection)this.getRawConnection()).getMetaData();
            try {
                DatabaseDefinitionRegistry dbDefRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
                DatabaseDefinition dbDef = dbDefRegistry.recognize((Connection)this.getRawConnection());
                if (dbDef != null) {
                    this.serverName = String.valueOf(dbDef.getProductDisplayString()) + " " + dbDef.getVersionDisplayString();
                }
            }
            catch (Exception exception) {}
            try {
                this.techVersion = new Version(dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion(), 0, new String());
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {}
    }

    public Throwable getConnectException() {
        Throwable exception = super.getConnectException();
        if (exception != null && exception instanceof SQLException && ((SQLException)exception).getErrorCode() == -4499 && exception.getCause() instanceof ConnectException) {
            exception = new DBNotStartException(exception);
        }
        return exception;
    }
}

