/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.Operation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2118
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public BP2118(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public void visit(Operation op, Object parent, WSDLTraversalContext ctx) {
        if (op == null) {
            this.errors.add(ctx.getBinding().getQName());
            ctx.cancelBindingProcessing();
            ctx.cancelBindingOperationProcessing();
        }
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        Binding b = (Binding)entryContext.getEntry().getEntryDetail();
        if (b.getPortType() == null || b.getPortType().getOperations().size() != b.getBindingOperations().size()) {
            this.errors.add(b.getQName());
        } else {
            WSDLTraversal traversal = new WSDLTraversal();
            traversal.setVisitor(this);
            traversal.visitOperation(true);
            traversal.traverse(b);
        }
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

