/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.server.ui.internal.ImageResource;

public class DefaultServerImageDescriptor
extends CompositeImageDescriptor {
    private Image fBaseImage;
    private Point fSize;
    private Image overlay;
    private int fFlags;
    public static final int BOTTOM_RIGHT = 1;

    public DefaultServerImageDescriptor(Image baseImage) {
        this(baseImage, ImageResource.getImage("defaultServerOverlay"));
    }

    public DefaultServerImageDescriptor(Image baseImage, Image overlay) {
        this.setBaseImage(baseImage);
        this.overlay = overlay;
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultServerImageDescriptor)) {
            return false;
        }
        DefaultServerImageDescriptor other = (DefaultServerImageDescriptor)((Object)object);
        return this.getBaseImage().equals((Object)other.getBaseImage());
    }

    public int hashCode() {
        return this.getBaseImage().hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        ImageData data = this.overlay.getImageData();
        Point size = this.getSize();
        int x = size.x - data.width;
        int y = 0;
        if ((this.fFlags & 1) != 0) {
            y = size.y - data.height;
        }
        this.drawImage(data, x, y);
    }

    protected Image getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(Image baseImage) {
        this.fBaseImage = baseImage;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }

    public void setFlags(int flags) {
        this.fFlags = flags;
    }
}

