/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.statistics.Statistics;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractSegmentStatisticsAnalysis
extends TmfAbstractAnalysisModule
implements IStatisticsAnalysis<ISegment> {
    private @Nullable ISegmentStoreProvider fSegmentStoreProvider;
    private @Nullable IStatistics<ISegment> fTotalStats;
    private Map<String, IStatistics<ISegment>> fPerSegmentTypeStats = new HashMap<String, IStatistics<ISegment>>();

    protected Function<ISegment, @Nullable Number> getMapper() {
        return ISegment::getLength;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            ISegmentStoreProvider provider;
            this.fSegmentStoreProvider = provider = this.getSegmentStoreProvider(trace);
            if (provider instanceof IAnalysisModule) {
                return ImmutableList.of((Object)((IAnalysisModule)provider));
            }
        }
        return super.getDependentAnalyses();
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        if (monitor.isCanceled()) {
            return false;
        }
        IStatistics<ISegment> totalStats = this.getTotalStats(TmfTimeRange.ETERNITY.getStartTime().toNanos(), TmfTimeRange.ETERNITY.getEndTime().toNanos(), monitor);
        if (totalStats == null) {
            return false;
        }
        Map<String, IStatistics<ISegment>> perTypeStats = this.getPerTypeStats(TmfTimeRange.ETERNITY.getStartTime().toNanos(), TmfTimeRange.ETERNITY.getEndTime().toNanos(), monitor);
        this.fTotalStats = totalStats;
        this.fPerSegmentTypeStats = perTypeStats;
        return true;
    }

    private @Nullable IStatistics<ISegment> getTotalStats(long start, long end, IProgressMonitor monitor) {
        Iterable<@NonNull ISegment> store = this.getSegmentStore(start, end);
        if (store == null) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return this.calculateTotalManual(store, monitor);
    }

    @Override
    public @Nullable IStatistics<ISegment> getStatsForRange(long start, long end, IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace != null && AbstractSegmentStatisticsAnalysis.isEternity(start, end)) {
            this.waitForCompletion();
            return this.getStatsTotal();
        }
        return this.getTotalStats(start, end, monitor);
    }

    private Map<@NonNull String, IStatistics<@NonNull ISegment>> getPerTypeStats(long start, long end, IProgressMonitor monitor) {
        Iterable<@NonNull ISegment> store = this.getSegmentStore(start, end);
        if (monitor.isCanceled() || store == null) {
            return Collections.emptyMap();
        }
        return this.calculateTotalPerType(store, monitor);
    }

    @Override
    public Map<@NonNull String, IStatistics<@NonNull ISegment>> getStatsPerTypeForRange(long start, long end, IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (trace != null && AbstractSegmentStatisticsAnalysis.isEternity(start, end)) {
            this.waitForCompletion();
            return this.getStatsPerType();
        }
        return this.getPerTypeStats(start, end, monitor);
    }

    private static boolean isEternity(long start, long end) {
        return start == TmfTimeRange.ETERNITY.getStartTime().toNanos() && end == TmfTimeRange.ETERNITY.getEndTime().toNanos();
    }

    private @Nullable Iterable<@NonNull ISegment> getSegmentStore(long start, long end) {
        ISegmentStoreProvider segmentStoreProvider = this.fSegmentStoreProvider;
        if (segmentStoreProvider == null) {
            return null;
        }
        if (segmentStoreProvider instanceof IAnalysisModule) {
            ((IAnalysisModule)segmentStoreProvider).waitForCompletion();
        }
        long t0 = Long.min(start, end);
        long t1 = Long.max(start, end);
        ISegmentStore<@NonNull ISegment> segmentStore = segmentStoreProvider.getSegmentStore();
        return segmentStore != null ? (AbstractSegmentStatisticsAnalysis.isEternity(t0, t1) ? segmentStore : segmentStore.getIntersectingElements(t0, t1)) : Collections.emptyList();
    }

    private @Nullable IStatistics<ISegment> calculateTotalManual(Iterable<@NonNull ISegment> segments, IProgressMonitor monitor) {
        Statistics<ISegment> total = new Statistics<ISegment>(this.getMapper());
        for (ISegment segment : segments) {
            if (monitor.isCanceled()) {
                return null;
            }
            total.update(segment);
        }
        return total;
    }

    private Map<@NonNull String, IStatistics<@NonNull ISegment>> calculateTotalPerType(Iterable<ISegment> segments, IProgressMonitor monitor) {
        HashMap<String, IStatistics<ISegment>> perSegmentTypeStats = new HashMap<String, IStatistics<ISegment>>();
        for (ISegment segment : segments) {
            if (monitor.isCanceled()) {
                return Collections.emptyMap();
            }
            String segmentType = this.getSegmentType(segment);
            if (segmentType == null) continue;
            IStatistics values = perSegmentTypeStats.getOrDefault(segmentType, new Statistics<ISegment>(this.getMapper()));
            values.update(segment);
            perSegmentTypeStats.put(segmentType, values);
        }
        return perSegmentTypeStats;
    }

    protected abstract @Nullable String getSegmentType(ISegment var1);

    @Deprecated
    protected abstract @Nullable ISegmentStoreProvider getSegmentProviderAnalysis(ITmfTrace var1);

    protected @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace trace) {
        return this.getSegmentProviderAnalysis(trace);
    }

    protected void canceling() {
    }

    @Override
    public @Nullable IStatistics<@NonNull ISegment> getStatsTotal() {
        return this.fTotalStats;
    }

    @Override
    public Map<String, IStatistics<@NonNull ISegment>> getStatsPerType() {
        return this.fPerSegmentTypeStats;
    }
}

