/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.combo;

import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.core.handler.ComboHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.Combo;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.widgets.Event;
import org.hamcrest.Matcher;

public abstract class AbstractCombo
extends AbstractControl<org.eclipse.swt.widgets.Combo>
implements Combo {
    private static final Logger log = Logger.getLogger(AbstractCombo.class);

    protected AbstractCombo(ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        super(org.eclipse.swt.widgets.Combo.class, refComposite, index, matchers);
    }

    protected AbstractCombo(org.eclipse.swt.widgets.Combo widget) {
        super(widget);
    }

    @Override
    public void setText(String str) {
        log.info("Set text of Combo " + this.getText() + " to:" + str);
        ComboHandler.getInstance().setText((org.eclipse.swt.widgets.Combo)this.swtWidget, str);
    }

    @Override
    public void setSelection(int index) {
        log.info("Set selection of Combo " + this.getText() + " to index: " + index);
        ComboHandler.getInstance().setSelection((org.eclipse.swt.widgets.Combo)this.swtWidget, index);
        this.notifyCombo(this.createEventForCombo(13));
    }

    @Override
    public void setSelection(String selection) {
        log.info("Set selection of Combo " + this.getText() + " to selection: " + selection);
        ComboHandler.getInstance().setSelection((org.eclipse.swt.widgets.Combo)this.swtWidget, selection);
        this.notifyCombo(this.createEventForCombo(13));
    }

    @Override
    public String getSelection() {
        return ComboHandler.getInstance().getSelection((org.eclipse.swt.widgets.Combo)this.swtWidget);
    }

    @Override
    public int getSelectionIndex() {
        return ComboHandler.getInstance().getSelectionIndex((org.eclipse.swt.widgets.Combo)this.swtWidget);
    }

    @Override
    public String getText() {
        return ComboHandler.getInstance().getText((org.eclipse.swt.widgets.Combo)this.swtWidget);
    }

    @Override
    public List<String> getItems() {
        return Arrays.asList(ComboHandler.getInstance().getItems((org.eclipse.swt.widgets.Combo)this.swtWidget));
    }

    private Event createEventForCombo(int type) {
        Event event = new Event();
        event.type = type;
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.widget = this.swtWidget;
        return event;
    }

    private void notifyCombo(final Event event) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ((org.eclipse.swt.widgets.Combo)AbstractCombo.this.swtWidget).notifyListeners(event.type, event);
            }
        });
    }
}

