/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.internal.core.model.Q7Element;

public class Q7ElementInfo {
    private List<IQ7Element> children;
    public static final Object[] NO_NON_Q7_RESOURCES = new Object[0];

    protected Q7ElementInfo() {
    }

    public void addChild(IQ7Element child) {
        if (this.children == null) {
            this.children = new ArrayList<IQ7Element>(5);
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public int size() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    protected IQ7Element get(int i) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(i);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public IQ7Element[] getChildren() {
        if (this.children == null) {
            return Q7Element.NO_ELEMENTS;
        }
        return this.children.toArray(new IQ7Element[this.children.size()]);
    }

    public List<IQ7Element> getChildrenAsList() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void removeChild(IQ7Element child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public <T extends IQ7Element> void setChildren(T[] children) {
        if (children == null) {
            this.children = null;
        } else {
            this.children = new ArrayList<IQ7Element>(children.length);
            int i = 0;
            while (i < children.length) {
                this.children.add((IQ7Element)children[i]);
                ++i;
            }
        }
    }

    public <T extends IQ7Element> void setChildren(List<T> children) {
        this.children = children == null ? null : new ArrayList<T>(children);
    }
}

