/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.eclipse.rap.rwt.testfixture.internal.TestServletContext;

public class TestHttpSession
implements HttpSession {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String id;
    private ServletContext servletContext = new TestServletContext();
    private boolean isInvalidated;
    private boolean newSession;
    private int maxInactiveInterval;

    public TestHttpSession() {
        this.id = String.valueOf(this.hashCode());
    }

    public long getCreationTime() {
        return 0L;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        if (this.isInvalidated) {
            String text = "Unable to obtain session id. Session already invalidated.";
            throw new IllegalStateException(text);
        }
        return this.id;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String arg0) {
        return this.attributes.get(arg0);
    }

    public Object getValue(String arg0) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        final Iterator<String> iterator = this.attributes.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    public String[] getValueNames() {
        return null;
    }

    public void setAttribute(String arg0, Object arg1) {
        if (arg1 instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)arg1;
            listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, arg0, arg1));
        }
        this.attributes.put(arg0, arg1);
    }

    public void putValue(String arg0, Object arg1) {
    }

    public void removeAttribute(String arg0) {
        Object removed = this.attributes.remove(arg0);
        if (removed instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)removed;
            HttpSessionBindingEvent evt = new HttpSessionBindingEvent((HttpSession)this, arg0, removed);
            listener.valueUnbound(evt);
        }
    }

    public void removeValue(String arg0) {
    }

    public void invalidate() {
        Object[] keys = this.attributes.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String key = (String)keys[i];
            Object value = this.attributes.get(key);
            if (value instanceof HttpSessionBindingListener) {
                HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, key, value));
            }
            ++i;
        }
        this.attributes.clear();
        this.isInvalidated = true;
    }

    public boolean isInvalidated() {
        return this.isInvalidated;
    }

    public boolean isNew() {
        return this.newSession;
    }

    public void setNew(boolean newSession) {
        this.newSession = newSession;
    }
}

