/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPProblemsConfigurationBlock
extends OptionsConfigurationBlock {
    private Composite fieldEditorParent;
    private Combo[] fields;
    private PixelConverter pixelConverter;
    private static Map<String, Category> model;

    public PHPProblemsConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, PHPProblemsConfigurationBlock.getKeys(), container);
    }

    private static void loadModel() {
        IConfigurationElement element;
        ArrayList<Category> categories = new ArrayList<Category>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui.problemConfiguration");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if ("category".equals(element.getName())) {
                categories.add(new Category(element.getAttribute("id"), element.getAttribute("name"), Integer.valueOf(element.getAttribute("priority"))));
            }
            ++n2;
        }
        categories.sort(new Comparator<Category>(){

            @Override
            public int compare(Category o1, Category o2) {
                return Integer.compare(o1.priority, o2.priority);
            }
        });
        model = new LinkedHashMap<String, Category>();
        categories.forEach(v -> {
            Category category = model.put(v.id, (Category)v);
        });
        iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui.problemConfiguration");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if ("problem".equals(element.getName())) {
                Category category = model.get(element.getAttribute("category"));
                if (category == null) {
                    PHPUiPlugin.logErrorMessage("Category not found: " + element.getAttribute("category"));
                } else {
                    IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("identifier");
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement identifier = iConfigurationElementArray2[n4];
                        String id = element.getAttribute("class") + '#' + identifier.getAttribute("id");
                        IProblemIdentifier ident = DefaultProblemIdentifier.decode((String)id);
                        category.problems.add(new ConcreteProblem(ident, identifier.getAttribute("name")));
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private static Key[] getKeys() {
        PHPProblemsConfigurationBlock.loadModel();
        ArrayList<Key> res = new ArrayList<Key>();
        for (Category cat : model.values()) {
            for (ConcreteProblem problem : cat.problems) {
                res.add(new Key(problem.qualifier, "severity"));
            }
        }
        return res.toArray(new Key[res.size()]);
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PHPUIMessages.PHPProblemsConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PHPUIMessages.PHPProblemsConfigurationBlock_needsfullbuild_message : PHPUIMessages.PHPProblemsConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    protected String[] getSeverityLabels() {
        return new String[]{PHPUIMessages.PHPProblemsConfigurationBlock_error, PHPUIMessages.PHPProblemsConfigurationBlock_warning, PHPUIMessages.PHPProblemsConfigurationBlock_info, PHPUIMessages.PHPProblemsConfigurationBlock_ignore};
    }

    protected String[] getSeverityValues() {
        return new String[]{ProblemSeverity.ERROR.toString(), ProblemSeverity.WARNING.toString(), ProblemSeverity.INFO.toString(), ProblemSeverity.IGNORE.toString()};
    }

    @Override
    public boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            return PHPCorePlugin.getDefault().getProblemPreferences().hasProjectSettings(project);
        }
        return false;
    }

    @Override
    public void useProjectSpecificSettings(boolean enable) {
        if (enable) {
            new ProjectScope(this.fProject).getNode("org.eclipse.php.core").node("pdt_validator").putBoolean("enabled", true);
        } else {
            new ProjectScope(this.fProject).getNode("org.eclipse.php.core").node("pdt_validator").remove("enabled");
        }
        super.useProjectSpecificSettings(enable);
    }

    private Composite createFields(Composite parent) {
        Composite fieldEditorParentWrap = new Composite(parent, 0);
        GridLayout wrapLayout = new GridLayout();
        wrapLayout.marginHeight = 0;
        wrapLayout.marginWidth = 0;
        fieldEditorParentWrap.setLayout((Layout)wrapLayout);
        fieldEditorParentWrap.setFont(parent.getFont());
        this.fieldEditorParent = new Composite(fieldEditorParentWrap, 0);
        this.fieldEditorParent.setLayout((Layout)new GridLayout());
        this.fieldEditorParent.setLayoutData((Object)new GridData(768));
        this.fieldEditorParent.setFont(parent.getFont());
        Label horizontalLine = new Label(this.fieldEditorParent, 258);
        horizontalLine.setLayoutData((Object)new GridData(768));
        horizontalLine.setFont(this.fieldEditorParent.getFont());
        this.fields = new Combo[this.fAllKeys.length];
        int i = 0;
        for (Category category : model.values()) {
            if (category.problems.size() == 0) continue;
            ExpandableComposite group = this.createGroup(1, this.fieldEditorParent, category.name);
            Composite inner = new Composite((Composite)group, 0);
            inner.setFont(parent.getFont());
            inner.setLayout((Layout)new GridLayout(3, false));
            inner.setLayoutData((Object)new GridData(768));
            group.setClient((Control)inner);
            for (ConcreteProblem v : category.problems) {
                Combo combo = this.fields[i] = this.addComboBox(inner, v.name, new Key(v.qualifier, "severity"), this.getSeverityValues(), this.getSeverityLabels(), 0);
                Label object = (Label)this.fLabels.get(combo);
                object.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
                ++i;
            }
        }
        return fieldEditorParentWrap;
    }

    protected ExpandableComposite createGroup(int numColumns, Composite parent, String label) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        excomposite.setExpanded(true);
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                PHPProblemsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        return excomposite;
    }

    @Override
    protected Control createContents(Composite parent) {
        if (this.pixelConverter == null) {
            this.pixelConverter = new PixelConverter((Control)parent);
        }
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new FillLayout(512));
        this.createFields(content);
        return content;
    }

    @Override
    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
    }

    private static class Category {
        private String id;
        private String name;
        private int priority;
        private List<ConcreteProblem> problems = new ArrayList<ConcreteProblem>();

        public Category(String id, String name, int priority) {
            this.id = id;
            this.name = name;
            this.priority = priority;
        }

        public boolean equals(Object obj) {
            return obj instanceof Category && ((Category)obj).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    private static class ConcreteProblem {
        private IProblemIdentifier identifier;
        private String name;
        private String qualifier;

        public ConcreteProblem(IProblemIdentifier identifier, String name) {
            this.name = name;
            this.identifier = identifier;
            this.qualifier = PHPCorePlugin.getDefault().getProblemPreferences().getPreferenceQualifier(identifier);
        }

        public boolean equals(Object obj) {
            return obj instanceof ConcreteProblem && ((ConcreteProblem)obj).identifier == this.identifier;
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }
    }
}

