/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.properties;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class AbstractProperties {
    private static final String SEPARATOR = "\n";
    private ProjectScope projScope = null;
    private ScopedPreferenceStore preferenceStore = null;

    private void initProjScope(IProject proj) {
        this.projScope = new ProjectScope(proj);
        this.preferenceStore = new ScopedPreferenceStore((IScopeContext)this.projScope, "org.eclipse.photran.core");
        this.initializeDefaults(proj, (IPreferenceStore)this.preferenceStore);
    }

    protected abstract void initializeDefaults(IProject var1, IPreferenceStore var2);

    public String getProperty(IFile file, String propertyName) {
        if (file == null || file.getProject() == null) {
            return "";
        }
        return this.getProperty(file.getProject(), propertyName);
    }

    public String[] getListProperty(IFile file, String propertyName) {
        return AbstractProperties.parseString(this.getProperty(file, propertyName));
    }

    protected void setProject(IProject project) {
        if (this.projScope == null || this.preferenceStore == null) {
            this.initProjScope(project);
        }
        IPath currPath = this.projScope.getLocation();
        IPath projPath = project.getLocation();
        if (currPath == null || projPath == null || !currPath.equals((Object)projPath.append(".settings"))) {
            this.initProjScope(project);
        }
    }

    public String getProperty(IProject project, String propertyName) {
        this.setProject(project);
        return this.preferenceStore.getString(propertyName);
    }

    public String[] getListProperty(IProject project, String propertyName) {
        return AbstractProperties.parseString(this.getProperty(project, propertyName));
    }

    public String getPropertyDefault(IProject project, String propertyName) {
        this.setProject(project);
        return this.preferenceStore.getDefaultString(propertyName);
    }

    public void setProperty(IProject project, String propertyName, String value) {
        this.setProject(project);
        this.preferenceStore.setValue(propertyName, value);
    }

    public void setListProperty(IProject project, String propertyName, String[] values) {
        this.setProject(project);
        this.preferenceStore.setValue(propertyName, AbstractProperties.createList(values));
    }

    public static String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                path.append(items[i]);
                path.append(SEPARATOR);
                ++i;
            }
        }
        return path.toString();
    }

    public static String[] parseString(String stringList) {
        if (stringList == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(stringList, "\n\n\r");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }

    public IPreferenceStore getPropertyStore(final IProject project, final String propertyName) {
        return new CustomPropertyStore(this){

            @Override
            protected String getProperty() {
                return this.getProperty(project, propertyName);
            }

            @Override
            protected String getDefault() {
                return this.getPropertyDefault(project, propertyName);
            }

            @Override
            protected void setProperty(String value) {
                this.setProperty(project, propertyName, value);
            }
        };
    }

    public IPreferenceStore getPropertyStore() {
        return this.preferenceStore;
    }

    public void save() throws IOException {
        this.preferenceStore.save();
    }

    private abstract class CustomPropertyStore
    implements IPreferenceStore {
        private CustomPropertyStore() {
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
        }

        public boolean contains(String name) {
            throw new Error();
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        }

        public boolean getBoolean(String name) {
            return this.getProperty().equals("true");
        }

        public boolean getDefaultBoolean(String name) {
            throw new Error();
        }

        public double getDefaultDouble(String name) {
            throw new Error();
        }

        public float getDefaultFloat(String name) {
            throw new Error();
        }

        public int getDefaultInt(String name) {
            throw new Error();
        }

        public long getDefaultLong(String name) {
            throw new Error();
        }

        public String getDefaultString(String name) {
            return this.getDefault();
        }

        public double getDouble(String name) {
            throw new Error();
        }

        public float getFloat(String name) {
            throw new Error();
        }

        public int getInt(String name) {
            throw new Error();
        }

        public long getLong(String name) {
            throw new Error();
        }

        public String getString(String name) {
            return this.getProperty();
        }

        public boolean isDefault(String name) {
            return this.getProperty() == null || this.getProperty().equals(this.getDefault());
        }

        public boolean needsSaving() {
            return false;
        }

        public void putValue(String name, String value) {
            this.setProperty(value);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
        }

        public void setDefault(String name, double value) {
        }

        public void setDefault(String name, float value) {
        }

        public void setDefault(String name, int value) {
        }

        public void setDefault(String name, long value) {
        }

        public void setDefault(String name, String defaultObject) {
            throw new Error();
        }

        public void setDefault(String name, boolean value) {
            this.setProperty(null);
        }

        public void setToDefault(String name) {
            this.setProperty(null);
        }

        public void setValue(String name, double value) {
        }

        public void setValue(String name, float value) {
        }

        public void setValue(String name, int value) {
        }

        public void setValue(String name, long value) {
        }

        public void setValue(String name, String value) {
            this.setProperty(value);
        }

        public void setValue(String name, boolean value) {
            this.setProperty(value ? "true" : "false");
        }

        protected abstract String getProperty();

        protected abstract String getDefault();

        protected abstract void setProperty(String var1);
    }
}

