/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.template;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;

public abstract class AbstractModelTemplateContentProvider
implements IStructuredContentProvider {
    protected static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.uml.diagram.wizards.templates";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_UML_FILE = "file";
    protected static final String ATTRIBUTE_NOTATION_FILE = "notation_file";
    protected static final String ATTRIBUTE_DI_FILE = "di_file";
    protected static final String ATTRIBUTE_LANGUAGE = "language";
    protected static final String TRANSFO_URI = "Transformation_URI";
    protected static final String SELECT_BY_DEFAULT = "selectedByDefault";
    protected ModelTemplateDescription[] myTemplateDescriptions;

    public void dispose() {
    }

    protected ModelTemplateDescription[] getTemplatesDescription() {
        if (this.myTemplateDescriptions == null) {
            IExtension[] extensions;
            ArrayList<ModelTemplateDescription> templates = new ArrayList<ModelTemplateDescription>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtension[] iExtensionArray = extensions = registry.getExtensionPoint(EXTENSION_POINT_ID).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                templates.addAll(this.processExtension(extension));
                ++n2;
            }
            this.myTemplateDescriptions = templates.toArray(new ModelTemplateDescription[templates.size()]);
        }
        return this.myTemplateDescriptions;
    }

    private Collection<ModelTemplateDescription> processExtension(IExtension extension) {
        ArrayList<ModelTemplateDescription> templates = new ArrayList<ModelTemplateDescription>();
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            ModelTemplateDescription template = new ModelTemplateDescription(configElement.getAttribute(ATTRIBUTE_NAME), extension.getContributor().getName(), configElement.getAttribute(ATTRIBUTE_UML_FILE), configElement.getAttribute(ATTRIBUTE_NOTATION_FILE), configElement.getAttribute(ATTRIBUTE_DI_FILE));
            template.setLanguage(configElement.getAttribute(ATTRIBUTE_LANGUAGE));
            template.setTransfo(configElement.getAttribute(TRANSFO_URI));
            template.setSelectedByDefault(Boolean.valueOf(configElement.getAttribute(SELECT_BY_DEFAULT)));
            templates.add(template);
            ++n2;
        }
        return templates;
    }

    public abstract Object[] getElements(Object var1);

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TableViewer) {
            ((TableViewer)viewer).add(this.getElements(null));
        }
    }
}

