/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.widgets;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.widgets.Composite;

public class StringWorkspaceFileSelector
extends AbstractPropertyEditor {
    protected org.eclipse.papyrus.infra.widgets.editors.StringWorkspaceFileSelector selector;
    protected String[] filterExtensions;
    protected String[] filterNames;
    protected boolean showOnlyCurrentProject = false;

    public StringWorkspaceFileSelector(Composite parent, int style) {
        this.selector = this.createSelector(parent, style);
        super.setEditor((AbstractValueEditor)this.selector);
    }

    protected org.eclipse.papyrus.infra.widgets.editors.StringWorkspaceFileSelector createSelector(Composite parent, int style) {
        return new org.eclipse.papyrus.infra.widgets.editors.StringWorkspaceFileSelector(parent, style);
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
        this.checkFilters();
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    @Override
    public void setProperty(String path) {
        super.setProperty(path);
        this.selector.setProjectName(this.getCurrentProjectName());
    }

    @Override
    public void setInput(DataSource input) {
        super.setInput(input);
        this.selector.setProjectName(this.getCurrentProjectName());
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
        this.checkFilters();
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    protected void checkFilters() {
        if (this.filterExtensions != null && this.filterNames != null) {
            this.selector.setFilters(this.filterExtensions, this.filterNames);
        }
    }

    public void setShowOnlyCurrentProject(boolean showOnlyCurrentProject) {
        this.showOnlyCurrentProject = showOnlyCurrentProject;
        this.selector.setShowOnlyCurrentProject(showOnlyCurrentProject);
    }

    protected final String getCurrentProjectName() {
        EObject source;
        URI uri;
        ModelElement modelElement;
        String currentProjectName = null;
        if (this.input != null && this.propertyPath != null && (modelElement = this.input.getModelElement(this.propertyPath)) instanceof EMFModelElement && (uri = (source = ((EMFModelElement)modelElement).getSource()).eResource().getURI()).isPlatformResource() && uri.segmentCount() >= 2) {
            currentProjectName = uri.segment(1);
        }
        return currentProjectName;
    }

    public boolean getShowOnlyCurrentProject() {
        return this.showOnlyCurrentProject;
    }
}

