/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MatrixRelationShipOwnerStrategy implements Enumerator
{
    DEFAULT(0, "DEFAULT", "DEFAULT"),
    TABLE_CONTEXT(1, "TABLE_CONTEXT", "TABLE_CONTEXT"),
    ROW_OWNER(2, "ROW_OWNER", "ROW_OWNER"),
    ROW_AS_OWNER(3, "ROW_AS_OWNER", "ROW_AS_OWNER"),
    COLUMN_OWNER(4, "COLUMN_OWNER", "COLUMN_OWNER"),
    COLUMN_AS_OWNER(5, "COLUMN_AS_OWNER", "COLUMN_AS_OWNER"),
    OTHER(6, "OTHER", "OTHER");

    public static final int DEFAULT_VALUE = 0;
    public static final int TABLE_CONTEXT_VALUE = 1;
    public static final int ROW_OWNER_VALUE = 2;
    public static final int ROW_AS_OWNER_VALUE = 3;
    public static final int COLUMN_OWNER_VALUE = 4;
    public static final int COLUMN_AS_OWNER_VALUE = 5;
    public static final int OTHER_VALUE = 6;
    private static final MatrixRelationShipOwnerStrategy[] VALUES_ARRAY;
    public static final List<MatrixRelationShipOwnerStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MatrixRelationShipOwnerStrategy[]{DEFAULT, TABLE_CONTEXT, ROW_OWNER, ROW_AS_OWNER, COLUMN_OWNER, COLUMN_AS_OWNER, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MatrixRelationShipOwnerStrategy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MatrixRelationShipOwnerStrategy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MatrixRelationShipOwnerStrategy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MatrixRelationShipOwnerStrategy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MatrixRelationShipOwnerStrategy get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return TABLE_CONTEXT;
            }
            case 2: {
                return ROW_OWNER;
            }
            case 3: {
                return ROW_AS_OWNER;
            }
            case 4: {
                return COLUMN_OWNER;
            }
            case 5: {
                return COLUMN_AS_OWNER;
            }
            case 6: {
                return OTHER;
            }
        }
        return null;
    }

    private MatrixRelationShipOwnerStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

