/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection.netty;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.netty.NettyStreamFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;

public class NettyStreamFactoryFactory
implements StreamFactoryFactory {
    private final EventLoopGroup eventLoopGroup;
    private final ByteBufAllocator allocator;

    public NettyStreamFactoryFactory(EventLoopGroup eventLoopGroup, ByteBufAllocator allocator) {
        this.eventLoopGroup = Assertions.notNull("eventLoopGroup", eventLoopGroup);
        this.allocator = Assertions.notNull("allocator", allocator);
    }

    public NettyStreamFactoryFactory() {
        this((EventLoopGroup)new NioEventLoopGroup(), ByteBufAllocator.DEFAULT);
    }

    @Override
    public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
        return new NettyStreamFactory(socketSettings, sslSettings, this.eventLoopGroup, this.allocator);
    }
}

