/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.values.IntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.RealValueImpl;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.RealValue;

public class BigIntegerValueImpl
extends IntegerValueImpl {
    private static final long serialVersionUID = 6202182719851208124L;
    private final @NonNull BigInteger value;

    public BigIntegerValueImpl(long value) {
        this(BigInteger.valueOf(value));
    }

    public BigIntegerValueImpl(@NonNull BigInteger value) {
        this.value = value;
        assert (value != null);
    }

    @Override
    public @NonNull IntegerValue abs() {
        @NonNull BigInteger result = this.value.abs();
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull IntegerValue addInteger(@NonNull IntegerValue right) {
        @NonNull BigInteger result = this.value.add(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull Double asDouble() {
        return this.value.doubleValue();
    }

    @Override
    public Object asEcoreObject(@NonNull IdResolver idResolver, @Nullable Class<?> instanceClass) {
        if (instanceClass == BigInteger.class) {
            return this.value;
        }
        return super.asEcoreObject(idResolver, instanceClass);
    }

    @Override
    public @NonNull Integer asInteger() {
        Integer result = this.intValue();
        return result;
    }

    @Override
    public @NonNull Number asNumber() {
        return this.value;
    }

    @Override
    public @NonNull Object asObject() {
        return this.value;
    }

    @Override
    public @NonNull Object asUnboxedObject(@NonNull IdResolver idResolver) {
        return this.value;
    }

    @Override
    public @NonNull BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    @Override
    public @NonNull BigInteger bigIntegerValue() {
        return this.value;
    }

    @Override
    public int commutatedCompareToInteger(@NonNull IntegerValue o) {
        try {
            return this.value.compareTo(o.bigIntegerValue());
        }
        catch (InvalidValueException e) {
            return this.hashCode() - o.hashCode();
        }
    }

    @Override
    public @NonNull IntegerValue divInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("div zero", new Object[0]);
        }
        @NonNull BigInteger result = this.value.divide(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull RealValue divideInteger(@NonNull IntegerValue right) {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(bigLeft, bigRight);
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof IntegerValue) {
                BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
                return this.value.compareTo(bigIntegerValue) == 0;
            }
            if (obj instanceof RealValue) {
                BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
                return this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return this == obj;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int intValue() {
        int intValue = this.value.intValue();
        return intValue;
    }

    @Override
    public boolean isUnlimitedNatural() {
        return this.signum() >= 0;
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public @NonNull IntegerValue maxInteger(@NonNull IntegerValue right) {
        return this.value.compareTo(right.bigIntegerValue()) >= 0 ? this : right;
    }

    @Override
    public @NonNull IntegerValue minInteger(@NonNull IntegerValue right) {
        return this.value.compareTo(right.bigIntegerValue()) <= 0 ? this : right;
    }

    @Override
    public @NonNull IntegerValue modInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("mod zero", new Object[0]);
        }
        @NonNull BigInteger result = this.value.remainder(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull IntegerValue multiplyInteger(@NonNull IntegerValue right) {
        @NonNull BigInteger result = this.value.multiply(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull IntegerValue negate() {
        @NonNull BigInteger result = this.value.negate();
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public @NonNull IntegerValue subtractInteger(@NonNull IntegerValue right) {
        @NonNull BigInteger result = this.value.subtract(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    public String toString() {
        return this.value.toString();
    }
}

