/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import org.eclipse.net4j.util.container.ContainerDelta;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;

public class LifecycleEventConverter<E>
implements IListener {
    private Notifier owner;

    public LifecycleEventConverter(Notifier owner) {
        this.owner = owner;
    }

    public INotifier getOwner() {
        return this.owner;
    }

    @Override
    public void notifyEvent(IEvent event) {
        if (event instanceof ILifecycleEvent) {
            ILifecycleEvent e = (ILifecycleEvent)event;
            switch (e.getKind()) {
                case ACTIVATED: {
                    this.added(e);
                    break;
                }
                case DEACTIVATED: {
                    this.removed(e);
                }
            }
        }
    }

    protected void added(ILifecycleEvent e) {
        this.fireContainerEvent(e, IContainerDelta.Kind.ADDED);
    }

    protected void removed(ILifecycleEvent e) {
        this.fireContainerEvent(e, IContainerDelta.Kind.REMOVED);
    }

    protected void fireContainerEvent(ILifecycleEvent e, IContainerDelta.Kind kind) {
        IListener[] listeners;
        ILifecycle element = e.getSource();
        if (element != null && (listeners = this.owner.getListeners()).length != 0) {
            this.owner.fireEvent(this.createContainerEvent((IContainer)((Object)this.owner), element, kind), listeners);
        }
    }

    protected IContainerEvent<E> createContainerEvent(IContainer<E> container, E element, IContainerDelta.Kind kind) {
        ContainerEvent<E> event = new ContainerEvent<E>(container);
        event.addDelta(new ContainerDelta<E>(element, kind));
        return event;
    }
}

