/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class ResolverConfiguration
implements Serializable {
    private static final long serialVersionUID = 1258510761534886581L;
    private boolean resolveWorkspaceProjects = true;
    private String selectedProfiles = "";
    private String lifecycleMappingId;
    private Properties properties;

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean shouldResolveWorkspaceProjects() {
        return this.resolveWorkspaceProjects;
    }

    public String getSelectedProfiles() {
        return this.selectedProfiles;
    }

    public List<String> getActiveProfileList() {
        return ResolverConfiguration.parseProfiles(this.selectedProfiles, true);
    }

    public List<String> getInactiveProfileList() {
        return ResolverConfiguration.parseProfiles(this.selectedProfiles, false);
    }

    public void setResolveWorkspaceProjects(boolean resolveWorkspaceProjects) {
        this.resolveWorkspaceProjects = resolveWorkspaceProjects;
    }

    public void setSelectedProfiles(String profiles) {
        this.selectedProfiles = profiles;
    }

    private static List<String> parseProfiles(String profilesAsText, boolean status) {
        ArrayList<String> profiles;
        if (profilesAsText != null && profilesAsText.trim().length() > 0) {
            String[] profilesArray = profilesAsText.split("[,\\s\\|]");
            profiles = new ArrayList(profilesArray.length);
            String[] stringArray = profilesArray;
            int n = profilesArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isActive;
                String profile = stringArray[n2];
                boolean bl = isActive = !profile.startsWith("!");
                if (status == isActive) {
                    profile = isActive ? profile : profile.substring(1);
                    profiles.add(profile);
                }
                ++n2;
            }
        } else {
            profiles = new ArrayList<String>(0);
        }
        return profiles;
    }

    public String getLifecycleMappingId() {
        return this.lifecycleMappingId;
    }

    public void setLifecycleMappingId(String lifecycleMappingId) {
        this.lifecycleMappingId = lifecycleMappingId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ResolverConfiguration other = (ResolverConfiguration)obj;
        return this.resolveWorkspaceProjects == other.resolveWorkspaceProjects && Objects.equals(this.selectedProfiles, other.selectedProfiles) && Objects.equals(this.lifecycleMappingId, other.lifecycleMappingId) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.resolveWorkspaceProjects, this.selectedProfiles, this.lifecycleMappingId, this.properties);
    }
}

