/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.util.Objects;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.MavenCapability;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;

public class MavenRequiredCapability
extends RequiredCapability {
    private static final long serialVersionUID = 3254716937353332553L;
    private final String versionRange;
    private final String scope;
    private final boolean optional;
    private final boolean resolved;

    private MavenRequiredCapability(String namespace, String id, String versionRange, String scope, boolean optional, boolean resolved) {
        super(namespace, id);
        if (versionRange == null) {
            throw new NullPointerException();
        }
        this.versionRange = versionRange;
        this.scope = scope;
        this.optional = optional;
        this.resolved = resolved;
    }

    public static MavenRequiredCapability createResolvedMavenArtifact(ArtifactKey key, String scope, boolean optional) {
        return new MavenRequiredCapability("maven-artifact", MavenCapability.getId(key), key.version(), scope, optional, true);
    }

    public static MavenRequiredCapability createMavenArtifact(ArtifactKey key, String scope, boolean optional) {
        return new MavenRequiredCapability("maven-artifact", MavenCapability.getId(key), key.version(), scope, optional, false);
    }

    public static MavenRequiredCapability createMavenArtifactImport(ArtifactKey key) {
        return new MavenRequiredCapability("maven-artifact-import", MavenCapability.getId(key), key.version(), "import", false, false);
    }

    public static MavenRequiredCapability createMavenParent(ArtifactKey key) {
        return new MavenRequiredCapability("maven-parent", MavenCapability.getId(key), key.version(), null, false, false);
    }

    public static MavenRequiredCapability createResolvedMavenParent(ArtifactKey key) {
        return new MavenRequiredCapability("maven-parent", MavenCapability.getId(key), key.version(), null, false, true);
    }

    @Override
    public boolean isPotentialMatch(Capability capability, boolean narrowMatch) {
        if (capability instanceof MavenCapability var3_4 && this.getVersionlessKey().equals(capability.getVersionlessKey())) {
            String version = mavenCapability.getVersion();
            if (this.resolved && narrowMatch) {
                return this.versionRange.equals(version);
            }
            try {
                VersionRange range = VersionRange.createFromVersionSpec((String)this.versionRange);
                return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(version));
            }
            catch (InvalidVersionSpecificationException ex) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionlessKey().toString());
        if (this.scope != null) {
            sb.append(':').append(this.scope);
        }
        sb.append('/').append(this.versionRange);
        if (this.optional) {
            sb.append("(optional)");
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = this.getVersionlessKey().hashCode();
        hash = hash * 17 + this.versionRange.hashCode();
        hash = hash * 17 + (this.scope != null ? this.scope.hashCode() : 0);
        hash = hash * 17 + (this.optional ? 1 : 0);
        return hash;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        void var3_2;
        MavenRequiredCapability mavenRequiredCapability;
        if (this == obj) {
            return true;
        }
        Object object = obj;
        return object instanceof MavenRequiredCapability && (mavenRequiredCapability = (MavenRequiredCapability)object) == (MavenRequiredCapability)var3_2 && this.getVersionlessKey().equals(other.getVersionlessKey()) && this.versionRange.equals(other.versionRange) && Objects.equals(this.scope, other.scope) && this.optional == other.optional;
    }
}

