/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectManager;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.workspace.MutableWorkspaceState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IMavenProjectChangedListener.class})
public class WorkspaceStateWriter
implements IMavenProjectChangedListener {
    private static QualifiedName PPROP_EXTENSION = new QualifiedName(WorkspaceStateWriter.class.getName(), "extension");
    private static final Logger log = LoggerFactory.getLogger(WorkspaceStateWriter.class);
    @Reference
    private MavenProjectManager projectManager;
    @Reference
    private IWorkspace workspace;

    @Override
    public void mavenProjectChanged(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        try {
            MutableWorkspaceState state = new MutableWorkspaceState();
            IWorkspaceRoot root = this.workspace.getRoot();
            for (IMavenProjectFacade projectFacade : this.projectManager.getProjects()) {
                IProject project = projectFacade.getProject();
                if (!project.isAccessible()) {
                    log.debug("Project registry contains closed project {}", (Object)project);
                    continue;
                }
                try {
                    File pom;
                    ArtifactKey artifact = projectFacade.getArtifactKey();
                    IFile pomFile = projectFacade.getPom();
                    IPath location = pomFile.getLocation();
                    if (location != null && (pom = location.toFile()).canRead()) {
                        state.putPom(pom, artifact.groupId(), artifact.artifactId(), artifact.version());
                    }
                    IResource outputLocation = root.findMember(projectFacade.getOutputLocation());
                    if (!"pom".equals(projectFacade.getPackaging()) && outputLocation != null && outputLocation.exists()) {
                        MavenProject mavenProject = projectFacade.getMavenProject();
                        String extension = mavenProject != null ? this.getAndPersistArtifactExtension(project, mavenProject) : project.getPersistentProperty(PPROP_EXTENSION);
                        if (extension == null && mavenProject == null) {
                            extension = this.getAndPersistArtifactExtension(project, projectFacade.getMavenProject(monitor));
                        }
                        if (extension != null) {
                            String classifier = artifact.classifier();
                            if (classifier == null) {
                                classifier = "";
                            }
                            state.putArtifact(outputLocation.getLocation().toFile(), artifact.groupId(), artifact.artifactId(), extension, classifier, artifact.version());
                        } else {
                            log.warn("Could not determine project {} main artifact extension.", (Object)project);
                        }
                    }
                    IResource testOutputLocation = root.findMember(projectFacade.getTestOutputLocation());
                    if ("pom".equals(projectFacade.getPackaging()) || testOutputLocation == null || !testOutputLocation.exists()) continue;
                    state.putArtifact(testOutputLocation.getLocation().toFile(), artifact.groupId(), artifact.artifactId(), "jar", "tests", artifact.version());
                }
                catch (CoreException ex) {
                    log.error("Error writing workspace state file", (Throwable)ex);
                }
            }
            state.store(this.projectManager.getWorkspaceStateFile());
        }
        catch (IOException ex) {
            log.error("Error writing workspace state file", (Throwable)ex);
        }
    }

    private String getAndPersistArtifactExtension(IProject project, MavenProject mavenProject) throws CoreException {
        String extension = mavenProject.getArtifact().getArtifactHandler().getExtension();
        project.setPersistentProperty(PPROP_EXTENSION, extension);
        return extension;
    }
}

