/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.archetype;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.IArchetype;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypeCatalogsWriter;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypeGenerator;
import org.eclipse.m2e.core.ui.internal.archetype.ExtensionReader;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Component(service={ArchetypePlugin.class})
public class ArchetypePlugin {
    public static final String ARCHETYPE_PREFIX = "archetype";
    private final Map<String, ArchetypeCatalogFactory> catalogs = new LinkedHashMap<String, ArchetypeCatalogFactory>();
    private final File configFile = new File(MavenPluginActivator.getDefault().getStateLocation().toFile(), "archetypesInfo.xml");
    private final ArchetypeCatalogsWriter writer = new ArchetypeCatalogsWriter();
    @Reference
    ArchetypeGenerator archetypeGenerator;
    @Reference
    IMaven maven;
    private ArchetypeArtifactManager archetypeArtifactManager;
    private Map<String, ArchetypeDataSource> archetypeDataSourceMap;
    private DefaultPlexusContainer container;

    @Activate
    void activate() throws IOException, PlexusContainerException, ComponentLookupException {
        AbstractModule logginModule = new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)LoggerFactory.getILoggerFactory());
            }
        };
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", ArchetypeArtifactManager.class.getClassLoader())).setClassPathScanning("index").setAutoWiring(true).setName("plexus");
        this.container = new DefaultPlexusContainer(cc, new Module[]{logginModule});
        this.archetypeArtifactManager = (ArchetypeArtifactManager)this.container.lookup(ArchetypeArtifactManager.class);
        this.archetypeDataSourceMap = this.container.lookupMap(ArchetypeDataSource.class);
        for (Map.Entry<String, ArchetypeDataSource> entry : this.archetypeDataSourceMap.entrySet()) {
            System.out.println(String.valueOf(entry.getKey()) + " :: " + entry.getValue());
        }
        System.out.println(this.archetypeArtifactManager);
        this.addArchetypeCatalogFactory(new ArchetypeCatalogFactory.InternalCatalogFactory(this.archetypeDataSourceMap.get("internal-catalog")));
        this.addArchetypeCatalogFactory(new ArchetypeCatalogFactory.DefaultLocalCatalogFactory(this.maven, this.archetypeDataSourceMap.get("catalog")));
        for (ArchetypeCatalogFactory archetypeCatalogFactory : ExtensionReader.readArchetypeExtensions(this)) {
            this.addArchetypeCatalogFactory(archetypeCatalogFactory);
        }
        this.readCatalogs();
    }

    @Deactivate
    void shutdown() throws IOException {
        this.saveCatalogs();
        this.container.dispose();
    }

    public ArchetypeCatalogFactory.LocalCatalogFactory newLocalCatalogFactory(String path, String description, boolean editable, boolean enabled) {
        return new ArchetypeCatalogFactory.LocalCatalogFactory(path, description, editable, enabled, this.maven, this.archetypeDataSourceMap.get("catalog"));
    }

    public ArchetypeCatalogFactory.RemoteCatalogFactory newRemoteCatalogFactory(String url, String description, boolean editable, boolean enabled) {
        return new ArchetypeCatalogFactory.RemoteCatalogFactory(url, description, editable, enabled, this.maven, this.archetypeDataSourceMap.get("remote-catalog"));
    }

    public ArchetypeGenerator getGenerator() {
        return this.archetypeGenerator;
    }

    public Collection<ArchetypeCatalogFactory> getArchetypeCatalogs() {
        return new ArrayList<ArchetypeCatalogFactory>(this.catalogs.values());
    }

    public Collection<ArchetypeCatalogFactory> getActiveArchetypeCatalogs() {
        return this.catalogs.values().stream().filter(ArchetypeCatalogFactory::isEnabled).collect(Collectors.toList());
    }

    public void addArchetypeCatalogFactory(ArchetypeCatalogFactory factory) {
        if (factory != null) {
            this.catalogs.put(factory.getId(), factory);
        }
    }

    public void removeArchetypeCatalogFactory(String catalogId) {
        this.catalogs.remove(catalogId);
    }

    public ArchetypeCatalogFactory getArchetypeCatalogFactory(String catalogId) {
        return this.catalogs.get(catalogId);
    }

    public void readCatalogs() throws IOException {
        if (this.configFile.exists()) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileInputStream is = new FileInputStream(this.configFile);){
                Collection<ArchetypeCatalogFactory> userDefinedCatalogs = this.writer.readArchetypeCatalogs(is, this.catalogs);
                for (ArchetypeCatalogFactory it : userDefinedCatalogs) {
                    this.addArchetypeCatalogFactory(it);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void saveCatalogs() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream os = new FileOutputStream(this.configFile);){
            this.writer.writeArchetypeCatalogs(this.getArchetypeCatalogs(), os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<RequiredProperty> getRequiredProperties(IArchetype archetype, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)archetype, (String)"Archetype can not be null");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String groupId = archetype.getGroupId();
        String artifactId = archetype.getArtifactId();
        String version = archetype.getVersion();
        ArrayList repositories = new ArrayList(this.maven.getArtifactRepositories());
        return (List)this.maven.createExecutionContext().execute((context, monitor1) -> {
            ArtifactRepository localRepository = context.getLocalRepository();
            if (this.archetypeArtifactManager.isFileSetArchetype(groupId, artifactId, version, null, localRepository, repositories, context.newProjectBuildingRequest())) {
                ArchetypeDescriptor descriptor;
                try {
                    descriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(groupId, artifactId, version, null, localRepository, repositories, context.newProjectBuildingRequest());
                }
                catch (UnknownArchetype ex) {
                    throw new CoreException(Status.error((String)"UnknownArchetype", (Throwable)ex));
                }
                return descriptor.getRequiredProperties();
            }
            return null;
        }, monitor);
    }

    public void updateLocalCatalog(Archetype archetype) throws CoreException {
        this.maven.createExecutionContext().execute((ctx, m) -> {
            ProjectBuildingRequest request = ctx.newProjectBuildingRequest();
            try {
                ArchetypeDataSource source = this.archetypeDataSourceMap.get("catalog");
                source.updateCatalog(request, archetype);
            }
            catch (ArchetypeDataSourceException archetypeDataSourceException) {
                // empty catch block
            }
            return null;
        }, null);
    }
}

