/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.jaxrslibraryregistry.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.ArchiveFile;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibraryRegistryFactory;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.PluginProvidedJAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.jaxrslibraryregistry.internal.PluginProvidedJAXRSLibraryArchiveFilesDelegate;
import org.eclipse.osgi.util.NLS;

public final class PluginProvidedJAXRSLibraryCreationHelper2 {
    private PluginProvidedJAXRSLibrary newLib;
    private IConfigurationElement config_element;
    private String relativeDestLocation = "WEB-INF/lib";
    public static final String NAME = "name";
    public static final String DELEGATE = "archiveFilesDelegate";
    public static final String LABEL = "label";

    public PluginProvidedJAXRSLibraryCreationHelper2(IConfigurationElement JAXRSLibrary2) {
        this.config_element = JAXRSLibrary2;
    }

    public void addArchiveFile(String pluginRootRelativePath) {
        ArchiveFile jar = this.createArchiveFile(pluginRootRelativePath);
        if (!this.newLib.containsArchiveFile(jar.getSourceLocation())) {
            this.newLib.getArchiveFiles().add((Object)jar);
        }
    }

    public void addArchiveFileFromFullPath(String path) throws Exception {
        ArchiveFile jar = this.createArchiveFileFromFullPath(path);
        if (!this.newLib.containsArchiveFile(jar.getSourceLocation())) {
            this.newLib.getArchiveFiles().add((Object)jar);
        }
    }

    private ArchiveFile createArchiveFileFromFullPath(String path) {
        ArchiveFile file = JAXRSLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        file.setRelativeToWorkspace(false);
        file.setSourceLocation(path);
        file.setRelativeDestLocation(this.relativeDestLocation);
        return file;
    }

    public JAXRSLibrary create() {
        this.newLib = JAXRSLibraryRegistryFactory.eINSTANCE.createPluginProvidedJAXRSLibrary();
        this.newLib.setPluginID(this.getPluginID());
        this.newLib.setName(this.config_element.getAttribute(NAME));
        String label = this.config_element.getAttribute(LABEL);
        if (label != null && label.length() > 0) {
            this.newLib.setLabel(label);
        }
        try {
            this.addArchives();
            return this.newLib;
        }
        catch (Exception e) {
            JAXRSCorePlugin.log(e, NLS.bind((String)Messages.PluginProvidedJAXRSLibraryCreationHelper_ErrorCreating, (Object)this.newLib.getName()));
            return null;
        }
    }

    private void addArchives() throws Exception {
        PluginProvidedJAXRSLibraryArchiveFilesDelegate jarCol = null;
        jarCol = (PluginProvidedJAXRSLibraryArchiveFilesDelegate)this.config_element.createExecutableExtension(DELEGATE);
        if (jarCol != null) {
            jarCol.setCreationHelper(this);
            jarCol.getArchiveFiles();
        }
    }

    private ArchiveFile createArchiveFile(String pluginRootRelativePath) {
        ArchiveFile file = JAXRSLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        file.setRelativeToWorkspace(false);
        file.setSourceLocation(pluginRootRelativePath);
        file.setRelativeDestLocation(this.relativeDestLocation);
        return file;
    }

    private String getPluginID() {
        return this.config_element.getDeclaringExtension().getContributor().getName();
    }
}

