/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaModel;

public class GenericJpaFile
extends AbstractJpaModel<JpaProject>
implements JpaFile {
    protected final IFile file;
    protected final IContentType contentType;
    protected final JptResourceModel resourceModel;
    protected final HashSet<JpaStructureNode> rootStructureNodes = new HashSet();

    public GenericJpaFile(JpaProject jpaProject, IFile file, IContentType contentType, JptResourceModel resourceModel) {
        super(jpaProject);
        this.file = file;
        this.contentType = contentType;
        this.resourceModel = resourceModel;
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("rootStructureNodes");
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    public IContentType getContentType() {
        return this.contentType;
    }

    @Override
    public JptResourceModel getResourceModel() {
        return this.resourceModel;
    }

    @Override
    public JptResourceModel getResourceModel(IContentType ct) {
        return this.contentType.isKindOf(ct) ? this.resourceModel : null;
    }

    @Override
    public Iterable<JpaStructureNode> getRootStructureNodes() {
        return IterableTools.cloneLive(this.rootStructureNodes);
    }

    @Override
    public int getRootStructureNodesSize() {
        return this.rootStructureNodes.size();
    }

    protected PersistenceXml getPersistenceXml() {
        return ((JpaProject)this.parent).getContextRoot().getPersistenceXml();
    }

    @Override
    public void updateRootStructureNodes() {
        PersistenceXml persistenceXml = this.getPersistenceXml();
        if (persistenceXml == null) {
            this.clearCollection(this.rootStructureNodes, "rootStructureNodes");
            return;
        }
        HashSet<JpaStructureNode> newRootStructureNodes = new HashSet<JpaStructureNode>();
        persistenceXml.addRootStructureNodesTo(this, newRootStructureNodes);
        this.synchronizeCollection(newRootStructureNodes, this.rootStructureNodes, "rootStructureNodes");
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        JpaStructureNode closestNode = null;
        int closestDistance = -1;
        for (JpaStructureNode currentNode : this.getRootStructureNodes()) {
            if (!currentNode.containsOffset(textOffset)) continue;
            int currentDistance = textOffset - currentNode.getFullTextRange().getOffset();
            if (closestNode == null) {
                closestNode = currentNode;
                closestDistance = currentDistance;
                continue;
            }
            if (currentDistance >= closestDistance) continue;
            closestNode = currentNode;
            closestDistance = currentDistance;
        }
        return closestNode == null ? null : closestNode.getStructureNode(textOffset);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.file);
        sb.append('[');
        sb.append(this.contentType.getName());
        sb.append(']');
    }
}

