/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.figures;

import java.util.ListIterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class WrapperNodeFigure
extends NodeFigure {
    private IFigure subFigure;

    public WrapperNodeFigure(IFigure subFigure) {
        this.setLayoutManager((LayoutManager)new StackLayout(){

            public boolean isObservingVisibility() {
                return true;
            }
        });
        this.add(subFigure);
        this.subFigure = subFigure;
    }

    public boolean containsPoint(int x, int y) {
        for (Figure figure : this.getChildren()) {
            if (!figure.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle getHandleBounds() {
        ListIterator li = this.getChildren().listIterator();
        Rectangle unionBounds = null;
        while (li.hasNext()) {
            IFigure fig = (IFigure)li.next();
            if (!fig.isVisible()) continue;
            Rectangle figBounds = fig.getBounds();
            if (fig instanceof NodeFigure) {
                figBounds = ((NodeFigure)fig).getHandleBounds();
            }
            if (unionBounds == null) {
                unionBounds = new Rectangle(figBounds);
                continue;
            }
            unionBounds.union(figBounds);
        }
        if (unionBounds != null) {
            return unionBounds;
        }
        return super.getHandleBounds();
    }

    @Override
    protected void paintFigure(Graphics graphics) {
    }

    public Border getBorder() {
        return super.getBorder();
    }

    public void setBorder(Border border) {
        this.subFigure.setBorder(border);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        if (this.subFigure instanceof NodeFigure) {
            return ((NodeFigure)this.subFigure).getSourceConnectionAnchorAt(p);
        }
        return super.getSourceConnectionAnchorAt(p);
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        if (this.subFigure instanceof NodeFigure) {
            return ((NodeFigure)this.subFigure).getTargetConnectionAnchorAt(p);
        }
        return super.getTargetConnectionAnchorAt(p);
    }

    @Override
    public ConnectionAnchor getConnectionAnchor(String terminal) {
        if (this.subFigure instanceof NodeFigure) {
            return ((NodeFigure)this.subFigure).getConnectionAnchor(terminal);
        }
        return super.getConnectionAnchor(terminal);
    }

    @Override
    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        if (this.subFigure instanceof NodeFigure) {
            return ((NodeFigure)this.subFigure).getConnectionAnchorTerminal(c);
        }
        return super.getConnectionAnchorTerminal(c);
    }
}

