/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.Draw2dRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderableObject;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.ITraceMe;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.Draw2dRenderDebugOptions;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public abstract class AbstractTranscoder {
    private static boolean m_gDebugMode = false;
    private Dimension m_size = new Dimension(100, 100);
    private String _thisClassName = null;

    static void setDebugMode() {
        m_gDebugMode = true;
    }

    static void logMessage(String message) {
        if (m_gDebugMode) {
            System.out.println(message);
        } else {
            Trace.trace((Plugin)Draw2dRenderPlugin.getInstance(), (String)Draw2dRenderDebugOptions.DEBUG, (String)message);
        }
    }

    public void setSize(Dimension size) {
        this.m_size = size;
    }

    public Dimension getSize() {
        return new Dimension(this.m_size);
    }

    public void transcode(InputStream input, OutputStream output) throws TranscoderException {
        this.transcode(input, output, "http://www.w3.org/2000/svg");
    }

    public void transcode(InputStream input, OutputStream output, String url) throws TranscoderException {
        if (input == null) {
            throw new IllegalArgumentException("Parameter 'input' may not be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Parameter 'output' may not be null");
        }
        try {
            BufferedInputStream stream = new BufferedInputStream(input);
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            String svgNS = url;
            SVGDocument doc = (SVGDocument)impl.createDocument(svgNS, "svg", null);
            SVGGraphics2D svg = new SVGGraphics2D((Document)doc);
            svg.getGeneratorContext().setPrecision(3);
            this.iterateRecords(stream, (Graphics2D)svg);
            svg.setSVGCanvasSize(this.m_size);
            OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
            svg.stream((Writer)writer);
        }
        catch (IOException e) {
            throw new TranscoderException(e);
        }
    }

    private void iterateRecords(BufferedInputStream stream, Graphics2D g) throws TranscoderException, IOException {
        Record rec;
        DeviceContext context = new DeviceContext();
        int index = 0;
        while ((rec = this.getNextRecord(stream, index)) != null) {
            ++index;
            try {
                String output = null;
                IRenderableObject svgConverter = this.getConverter(rec);
                if (svgConverter != null) {
                    if (context.getGdiPath().isOpen() && svgConverter instanceof IRenderToPath) {
                        IRenderToPath pathRender = (IRenderToPath)((Object)svgConverter);
                        pathRender.render(context);
                        if (m_gDebugMode) {
                            output = this.buildOutput(rec, "IRenderToPath", index);
                        }
                    } else {
                        svgConverter.render(g, context);
                        if (m_gDebugMode) {
                            output = this.buildOutput(rec, "IRenderableObject", index);
                        }
                    }
                    if (m_gDebugMode && svgConverter instanceof ITraceMe) {
                        output = String.valueOf(output) + ' ' + svgConverter.toString();
                    }
                } else {
                    output = this.buildOutput(rec, "Unhandled", index);
                }
                AbstractTranscoder.logMessage(output);
            }
            catch (org.apache.batik.transcoder.TranscoderException e) {
                throw new TranscoderException((Exception)((Object)e));
            }
            catch (TranscoderException e) {
                throw e;
            }
            catch (Exception e) {
                String output = String.valueOf(this.buildOutput(rec, "Exception while processing", index)) + ":\n" + e.toString();
                AbstractTranscoder.logMessage(output);
                e.printStackTrace();
            }
        }
    }

    private String buildOutput(Record rec, String msg, int ix) {
        if (this._thisClassName == null) {
            this._thisClassName = this.getClass().getName();
            this._thisClassName = this._thisClassName.substring(this._thisClassName.lastIndexOf(46) + 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._thisClassName);
        sb.append(", record " + ix + ' ');
        sb.append(String.valueOf(msg) + "  metafile record type ");
        sb.append(String.valueOf(rec.getType()) + " = " + this.getUserFriendlyName(rec.getType()));
        return sb.toString();
    }

    protected abstract Record getNextRecord(BufferedInputStream var1, int var2) throws IOException;

    protected abstract IRenderableObject getConverter(Record var1) throws TranscoderException;

    protected abstract String getUserFriendlyName(int var1);
}

