/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.resources;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileChangeEvent;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileChangeEventType;
import org.eclipse.gmf.runtime.common.ui.internal.resources.IFileChangeManager;
import org.eclipse.gmf.runtime.common.ui.internal.resources.MarkerChangeEvent;
import org.eclipse.gmf.runtime.common.ui.internal.resources.MarkerChangeEventType;
import org.eclipse.gmf.runtime.common.ui.resources.FileModificationValidator;
import org.eclipse.gmf.runtime.common.ui.resources.FileObserverManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;

public class FileChangeManager
implements IResourceChangeListener,
IResourceDeltaVisitor,
IFileChangeManager {
    private static FileChangeManager INSTANCE = new FileChangeManager();
    private FileObserverManager fileObserverManager = new FileObserverManager();

    public static FileChangeManager getInstance() {
        return INSTANCE;
    }

    private FileChangeManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public final void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"resourceChanged", (Throwable)e);
                    Log.warning((Plugin)CommonUIPlugin.getDefault(), (int)7, (String)e.getMessage(), (Throwable)e);
                }
                break;
            }
        }
    }

    public final boolean visit(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                if ((delta.getFlags() & 0x1000) != 0) {
                    if (delta.getMovedFromPath().removeLastSegments(1).equals((Object)delta.getResource().getFullPath().removeLastSegments(1))) {
                        if (Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) {
                            Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)("...FileChangeManager: Resource " + this.getAbsolutePath(delta.getResource()) + " was renamed from " + delta.getMovedFromPath().toString()));
                        }
                        if (!(delta.getResource() instanceof IFile)) break;
                        FileChangeEvent event = new FileChangeEvent(FileChangeEventType.RENAMED, (IFile)FileChangeManager.getMovedFromResource(delta), (IFile)delta.getResource());
                        this.fileObserverManager.notify(event);
                        break;
                    }
                    if (Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) {
                        Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)("...FileChangeManager: Resource " + this.getAbsolutePath(delta.getResource()) + " was moved from " + delta.getMovedFromPath().toString()));
                    }
                    if (!(delta.getResource() instanceof IFile)) break;
                    FileChangeEvent event = new FileChangeEvent(FileChangeEventType.MOVED, (IFile)FileChangeManager.getMovedFromResource(delta), (IFile)delta.getResource());
                    this.fileObserverManager.notify(event);
                    break;
                }
                if (delta.getResource() instanceof IFile) {
                    FileChangeEvent event = new FileChangeEvent(FileChangeEventType.CHANGED, (IFile)delta.getResource());
                    this.fileObserverManager.notify(event);
                    if (!Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) break;
                    Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)("...FileChangeManager: Resource " + this.getAbsolutePath(delta.getResource()) + " was added"));
                    break;
                }
                if (!Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) break;
                Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)("...FileChangeManager: Resource " + this.getAbsolutePath(delta.getResource()) + " was added"));
                break;
            }
            case 2: {
                if ((delta.getFlags() & 0x2000) != 0) break;
                if (Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) {
                    Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)("...FileChangeManager: Resource " + this.getAbsolutePath(delta.getResource()) + " was deleted"));
                }
                if (!(delta.getResource() instanceof IFile)) break;
                FileChangeEvent event = new FileChangeEvent(FileChangeEventType.DELETED, (IFile)delta.getResource());
                this.fileObserverManager.notify(event);
                break;
            }
            case 4: {
                if (Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) {
                    Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)("...FileChangeManager: Resource " + this.getAbsolutePath(delta.getResource()) + " was changed"));
                }
                if ((delta.getFlags() & 0x20000) != 0) {
                    List<IMarkerDelta> markers = Arrays.asList(delta.getMarkerDeltas());
                    Iterator<IMarkerDelta> i = markers.iterator();
                    while (i.hasNext()) {
                        if (Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) {
                            Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)("...FileChangeManager: Resource marker of " + this.getAbsolutePath(delta.getResource()) + " was changed"));
                        }
                        MarkerChangeEvent event = null;
                        IMarkerDelta markerDelta = i.next();
                        switch (markerDelta.getKind()) {
                            case 1: {
                                event = new MarkerChangeEvent(MarkerChangeEventType.ADDED, markerDelta.getMarker());
                                this.fileObserverManager.notify(event);
                                break;
                            }
                            case 2: {
                                event = new MarkerChangeEvent(MarkerChangeEventType.REMOVED, markerDelta.getMarker(), markerDelta.getAttributes());
                                this.fileObserverManager.notify(event);
                                break;
                            }
                            case 4: {
                                event = new MarkerChangeEvent(MarkerChangeEventType.CHANGED, markerDelta.getMarker());
                                this.fileObserverManager.notify(event);
                                break;
                            }
                        }
                    }
                    break;
                }
                if (!(delta.getResource() instanceof IFile)) break;
                FileChangeEvent event = new FileChangeEvent(FileChangeEventType.CHANGED, (IFile)delta.getResource());
                this.fileObserverManager.notify(event);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean okToEdit(IFile[] files, String modificationReason) {
        return FileModificationValidator.getInstance().okToEdit(files, modificationReason);
    }

    @Override
    public boolean okToSave(IFile file) {
        return FileModificationValidator.getInstance().okToSave(file);
    }

    @Override
    public void removeFileObserver(IFileObserver fileObserver) {
        this.fileObserverManager.remove(fileObserver);
    }

    @Override
    public void addFileObserver(IFileObserver fileObserver, IFile fileFilter) {
        this.fileObserverManager.add(fileObserver, fileFilter);
    }

    @Override
    public void addFileObserver(IFileObserver fileObserver, IContentType[] contentTypeFilter) {
        this.fileObserverManager.add(fileObserver, contentTypeFilter);
    }

    @Override
    public void addFileObserver(IFileObserver fileObserver, IFolder folderFilter) {
        this.fileObserverManager.add(fileObserver, folderFilter);
    }

    @Override
    public void addFileObserver(IFileObserver fileObserver, String[] extensionFilter) {
        this.fileObserverManager.add(fileObserver, extensionFilter);
    }

    @Override
    public void addFileObserver(IFileObserver fileObserver) {
        this.fileObserverManager.add(fileObserver);
    }

    @Override
    public void refreshLocal(final IFile file) {
        try {
            file.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (Trace.shouldTrace((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.RESOURCE)) {
                        Trace.trace((Plugin)CommonUIPlugin.getDefault(), (String)("...FileChangeManager: Resource " + FileChangeManager.this.getAbsolutePath((IResource)file) + " was refreshed"));
                    }
                    file.refreshLocal(0, null);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"refreshResource", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)4, (String)e.getMessage(), (Throwable)e);
        }
    }

    public static IResource getMovedFromResource(IResourceDelta delta) {
        IPath movedFromPath = delta.getMovedFromPath();
        IResource resource = delta.getResource();
        IFolder movedResource = null;
        switch (resource.getType()) {
            case 4: {
                movedResource = ResourcesPlugin.getWorkspace().getRoot().getProject(movedFromPath.lastSegment());
                break;
            }
            case 2: {
                movedResource = ResourcesPlugin.getWorkspace().getRoot().getFolder(movedFromPath);
                break;
            }
            case 1: {
                movedResource = ResourcesPlugin.getWorkspace().getRoot().getFile(movedFromPath);
                break;
            }
        }
        return movedResource;
    }

    private String getAbsolutePath(IResource resource) {
        if (resource.getLocationURI() == null) {
            return resource.getFullPath().toString();
        }
        return resource.getLocationURI().toString();
    }
}

