/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.RowIntrospectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class EMFIntrospectionProvider
extends RowIntrospectionProvider {
    protected static final int PRIORITY = 80;
    protected static final int CATEGORY = -20;
    private static final String E_CONTAINER = "eContainer";
    private static final String E_CLASS = "eClass";
    private static final String E_IS_PROXY = "eIsProxy";
    private static final String E_DELIVER = "eDeliver";
    private static final String E_ADAPTERS = "eAdapters";
    private static final String E_RESOURCE = "eResource";
    private static final String E_URI = "eURI";
    private final Color foreground = Display.getDefault().getSystemColor(10);

    public EMFIntrospectionProvider() {
        super(EObject.class.getName(), "EObject");
    }

    protected EMFIntrospectionProvider(String id, String label) {
        super(id, label);
    }

    public int getPriority() {
        return 80;
    }

    public void attachListener(TableViewer viewer, Object value) {
        super.attachListener(viewer, value);
        if (value instanceof Notifier) {
            Notifier notifier = (Notifier)value;
            ValueAdapter adapter = new ValueAdapter(viewer);
            notifier.eAdapters().add((Object)adapter);
        }
    }

    public void detachListener(TableViewer viewer, Object value) {
        if (value instanceof Notifier) {
            Notifier notifier = (Notifier)value;
            Iterator it = notifier.eAdapters().iterator();
            while (it.hasNext()) {
                Adapter adapter = (Adapter)it.next();
                if (adapter.getClass() != ValueAdapter.class) continue;
                it.remove();
            }
        }
        super.detachListener(viewer, value);
    }

    public boolean canHandle(Object object) {
        return object instanceof EObject;
    }

    protected void fillRows(Object parent, List<RowIntrospectionProvider.Row> rows) throws Exception {
        EObject eObject = (EObject)parent;
        rows.add(this.createEContainerRow(eObject));
        rows.add(this.createEURIRow(eObject));
        rows.add(this.createEResourceRow(eObject));
        rows.add(this.createEClassRow(eObject));
        rows.add(this.createEIsProxyRow(eObject));
        rows.add(this.createEDeliverRow(eObject));
        rows.add(this.createEAdaptersRow(eObject));
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            rows.add(EMFIntrospectionProvider.createRow(eObject, feature));
        }
    }

    public RowIntrospectionProvider.Row getElementByName(Object parent, String name) throws Exception {
        EObject eObject = (EObject)parent;
        if (E_CONTAINER.equals(name)) {
            return this.createEContainerRow(eObject);
        }
        if (E_CLASS.equals(name)) {
            return this.createEClassRow(eObject);
        }
        if (E_IS_PROXY.equals(name)) {
            return this.createEIsProxyRow(eObject);
        }
        if (E_DELIVER.equals(name)) {
            return this.createEDeliverRow(eObject);
        }
        if (E_ADAPTERS.equals(name)) {
            return this.createEAdaptersRow(eObject);
        }
        if (E_RESOURCE.equals(name)) {
            return this.createEResourceRow(eObject);
        }
        if (E_URI.equals(name)) {
            return this.createEURIRow(eObject);
        }
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature(name);
        if (feature != null) {
            return EMFIntrospectionProvider.createRow(eObject, feature);
        }
        return null;
    }

    private RowIntrospectionProvider.Row createEContainerRow(EObject eObject) {
        return EMFIntrospectionProvider.createRow(E_CONTAINER, eObject.eContainer(), EObject.class.getName(), -20, this.foreground);
    }

    private RowIntrospectionProvider.Row createEURIRow(EObject eObject) {
        return EMFIntrospectionProvider.createRow(E_URI, EcoreUtil.getURI((EObject)eObject), URI.class.getName(), -20, this.foreground);
    }

    private RowIntrospectionProvider.Row createEResourceRow(EObject eObject) {
        return EMFIntrospectionProvider.createRow(E_RESOURCE, eObject.eResource(), Resource.class.getName(), -20, this.foreground);
    }

    private RowIntrospectionProvider.Row createEClassRow(EObject eObject) {
        return EMFIntrospectionProvider.createRow(E_CLASS, eObject.eClass(), EClass.class.getName(), -20, this.foreground);
    }

    private RowIntrospectionProvider.Row createEIsProxyRow(EObject eObject) {
        return EMFIntrospectionProvider.createRow(E_IS_PROXY, eObject.eIsProxy(), Boolean.TYPE.getName(), -20, this.foreground);
    }

    private RowIntrospectionProvider.Row createEDeliverRow(EObject eObject) {
        return EMFIntrospectionProvider.createRow(E_DELIVER, eObject.eDeliver(), Boolean.TYPE.getName(), -20, this.foreground);
    }

    private RowIntrospectionProvider.Row createEAdaptersRow(EObject eObject) {
        return EMFIntrospectionProvider.createRow(E_ADAPTERS, eObject.eAdapters(), "EList<Adapter>", -20, this.foreground);
    }

    private static RowIntrospectionProvider.Row createRow(EObject eObject, EStructuralFeature feature) {
        Object value = eObject.eGet(feature);
        return new RowIntrospectionProvider.Row(feature.getName(), value, EMFIntrospectionProvider.getDeclaredType(feature), EMFIntrospectionProvider.getConcreteType(value));
    }

    protected static RowIntrospectionProvider.Row createRow(String name, Object value, String declaredType, int category, Color foreground) {
        return new RowIntrospectionProvider.Row(name, value, declaredType, EMFIntrospectionProvider.getConcreteType(value), category, foreground, null);
    }

    private static String getDeclaredType(EStructuralFeature feature) {
        String result = feature.getEType().getName();
        int lowerBound = feature.getLowerBound();
        int upperBound = feature.getUpperBound();
        if (lowerBound != 0 || upperBound != 1) {
            result = String.valueOf(result) + "[" + lowerBound + "..";
            result = upperBound == -1 ? String.valueOf(result) + "*" : String.valueOf(result) + upperBound;
            result = String.valueOf(result) + "]";
        }
        return result;
    }

    private static String getConcreteType(Object value) {
        if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            return eObject.eClass().getName();
        }
        return EMFIntrospectionProvider.getClassName((Object)value);
    }

    private static final class ValueAdapter
    extends AdapterImpl {
        private final TableViewer viewer;

        private ValueAdapter(TableViewer viewer) {
            this.viewer = viewer;
        }

        public void notifyChanged(Notification msg) {
            UIUtil.refreshViewer((Viewer)this.viewer);
        }
    }
}

