/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IImportContainer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageElement;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageFragment;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageSourceModule;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesElement;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesFragment;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesSourceModule;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.templates.TclTemplateAccess;
import org.eclipse.dltk.tcl.internal.ui.text.SimpleTclSourceViewerConfiguration;
import org.eclipse.dltk.ui.AbstractDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;

public class TclUILanguageToolkit
extends AbstractDLTKUILanguageToolkit {
    private static TclUILanguageToolkit sToolkit = null;
    private static TclScriptElementLabels sInstance = new TclScriptElementLabels();
    private static final String INTERPRETERS_PREFERENCE_PAGE_ID = "org.eclipse.dltk.tcl.preferences.interpreters";
    private static final String DEBUG_PREFERENCE_PAGE_ID = "org.eclipse.dltk.tcl.preferences.debug";
    private static final String[] EDITOR_PREFERENCE_PAGES_IDS = new String[]{"org.eclipse.dltk.tcl.preferences.editor", "org.eclipse.dltk.tcl.preferences.templates", "org.eclipse.dltk.tcl.preferences.editor.syntaxcoloring", "org.eclipse.dltk.tcl.preferences.editor.hovers", "org.eclipse.dltk.tcl.preferences.editor.smarttyping", "org.eclipse.dltk.tcl.preferences.editor.folding", "org.eclipse.dltk.tcl.ui.assistance"};

    public static synchronized IDLTKUILanguageToolkit getInstance() {
        if (sToolkit == null) {
            sToolkit = new TclUILanguageToolkit();
        }
        return sToolkit;
    }

    public ScriptElementLabels getScriptElementLabels() {
        return sInstance;
    }

    public IPreferenceStore getPreferenceStore() {
        return TclUI.getDefault().getPreferenceStore();
    }

    public IDLTKLanguageToolkit getCoreToolkit() {
        return TclLanguageToolkit.getDefault();
    }

    public IDialogSettings getDialogSettings() {
        return TclUI.getDefault().getDialogSettings();
    }

    public String getPartitioningId() {
        return "__tcl_partitioning";
    }

    public String getEditorId(Object inputElement) {
        return "org.eclipse.dltk.tcl.ui.editor.TclEditor";
    }

    public String getInterpreterContainerId() {
        return "org.eclipse.dltk.tcl.launching.INTERPRETER_CONTAINER";
    }

    public ScriptUILabelProvider createScriptUILabelProvider() {
        return null;
    }

    public boolean getProvideMembers(ISourceModule element) {
        return true;
    }

    public ScriptTextTools getTextTools() {
        return TclUI.getDefault().internalgetTextTools();
    }

    public ScriptSourceViewerConfiguration createSourceViewerConfiguration() {
        return new SimpleTclSourceViewerConfiguration(this.getTextTools().getColorManager(), this.getPreferenceStore(), null, this.getPartitioningId(), false);
    }

    public String getInterpreterPreferencePage() {
        return INTERPRETERS_PREFERENCE_PAGE_ID;
    }

    public String getDebugPreferencePage() {
        return DEBUG_PREFERENCE_PAGE_ID;
    }

    public String[] getEditorPreferencePages() {
        return EDITOR_PREFERENCE_PAGES_IDS;
    }

    public ITemplateAccess getEditorTemplates() {
        return TclTemplateAccess.getInstance();
    }

    private static class TclScriptElementLabels
    extends ScriptElementLabels {
        private TclScriptElementLabels() {
        }

        public void getElementLabel(IModelElement element, long flags, StringBuffer buf) {
            StringBuffer buffer = new StringBuffer(60);
            super.getElementLabel(element, flags, buffer);
            String s = buffer.toString();
            if (s != null && !s.startsWith(element.getElementName()) && s.indexOf(36) != -1) {
                s = s.replaceAll("\\$", "::");
            }
            buf.append(s);
        }

        protected void getImportContainerLabel(IModelElement element, long flags, StringBuffer buf) {
            IImportContainer container = (IImportContainer)element;
            if ("source".equals(container.getContainerName())) {
                buf.append("sourced files");
            } else if ("require".equals(container.getContainerName())) {
                buf.append("required packages");
            } else {
                super.getImportContainerLabel(element, flags, buf);
            }
        }

        public void getScriptFolderLabel(IProjectFragment pack, long flags, StringBuffer buf) {
            if (pack instanceof TclPackageFragment || pack instanceof TclSourcesFragment) {
                return;
            }
            super.getScriptFolderLabel(pack, flags, buf);
        }

        public void getProjectFragmentLabel(IProjectFragment root, long flags, StringBuffer buf) {
            if (root instanceof TclPackageFragment) {
                buf.append(((TclPackageFragment)root).getPackageName());
                buf.append(' ');
                return;
            }
            super.getProjectFragmentLabel(root, flags, buf);
        }

        protected void getScriptFolderLabel(IScriptFolder folder, long flags, StringBuffer buf) {
            if (TclScriptElementLabels.getFlag((long)flags, (long)0x800000000L)) {
                this.getProjectFragmentLabel((IProjectFragment)folder.getParent(), 0x20000000000L, buf);
                buf.append('/');
            }
            if (!folder.isRootFolder()) {
                if (TclScriptElementLabels.getFlag((long)flags, (long)0x2000000000L) && fgPkgNameLength >= 0) {
                    String name = folder.getElementName();
                    int start = 0;
                    int dot = name.indexOf(47, start);
                    while (dot > 0) {
                        if (dot - start > fgPkgNameLength - 1) {
                            buf.append(fgPkgNamePrefix);
                            if (fgPkgNameChars > 0) {
                                buf.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                            }
                            buf.append(fgPkgNamePostfix);
                        } else {
                            buf.append(name.substring(start, dot + 1));
                        }
                        start = dot + 1;
                        dot = name.indexOf(47, start);
                    }
                    buf.append(name.substring(start));
                } else {
                    this.getScriptFolderLabel(folder, buf);
                }
            }
            if (TclScriptElementLabels.getFlag((long)flags, (long)0x1000000000L)) {
                this.getProjectFragmentLabel((IProjectFragment)folder.getParent(), 0x20000000000L, buf);
            }
        }

        protected void getScriptFolderLabel(IScriptFolder folder, StringBuffer buf) {
            if (folder instanceof TclPackageElement || folder instanceof TclSourcesElement) {
                return;
            }
            String name = folder.getElementName();
            buf.append(name);
        }

        protected void getSourceModule(ISourceModule module, long flags, StringBuffer buf) {
            if (TclScriptElementLabels.getFlag((long)flags, (long)0x80000000L)) {
                IScriptFolder pack = (IScriptFolder)module.getParent();
                this.getScriptFolderLabel(pack, flags & 0x1002000000000L, buf);
            }
            buf.append(module.getElementName());
            if (TclScriptElementLabels.getFlag((long)flags, (long)0x100000000L)) {
                if (!(module instanceof TclPackageSourceModule) && !(module instanceof TclSourcesSourceModule)) {
                    buf.append(" - ");
                }
                this.getScriptFolderLabel((IScriptFolder)module.getParent(), flags & 0x1002000000000L, buf);
            }
        }
    }
}

