/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains interfaces for {@link org.eclipse.collections.api.multimap.list.ListMultimap}.
 * <p>
 *     A ListMultimap is a type of {@link org.eclipse.collections.api.multimap.Multimap} that stores the values for keys in a {@link org.eclipse.collections.api.list.MutableList}.
 * <p>
 * This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link org.eclipse.collections.api.multimap.list.ListMultimap} - A Read-only List Multimap API.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.multimap.list.MutableListMultimap} - Modifiable List multimap.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.multimap.list.ImmutableListMultimap} - Non-modifiable equivalent interface to {@link org.eclipse.collections.api.multimap.list.MutableListMultimap}.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.api.multimap.list;
