/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.provider;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.internal.qt.core.QtInstall;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallProvider;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.Platform;

public class Msys2QtInstallProvider
implements IQtInstallProvider {
    @Override
    public Collection<IQtInstall> getInstalls() {
        if (Platform.getOS().equals("win32")) {
            String subkey;
            ArrayList<IQtInstall> installs = new ArrayList<IQtInstall>();
            WindowsRegistry registry = WindowsRegistry.getRegistry();
            String uninstallKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
            int i = 0;
            while ((subkey = registry.getCurrentUserKeyName(uninstallKey, i)) != null) {
                String compKey = String.valueOf(uninstallKey) + '\\' + subkey;
                String displayName = registry.getCurrentUserValue(compKey, "DisplayName");
                if ("MSYS2 64bit".equals(displayName)) {
                    String installLocation = registry.getCurrentUserValue(compKey, "InstallLocation");
                    Path qmakePath = Paths.get(String.valueOf(installLocation) + "\\mingw64\\bin\\qmake.exe", new String[0]);
                    QtInstall install = new QtInstall(qmakePath);
                    install.setProperty("package", "msys2");
                    installs.add(install);
                }
                ++i;
            }
            return installs;
        }
        return Collections.emptyList();
    }
}

