/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.qt.core.pdom.QmlTypeRegistration;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMBinding;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMLinkage;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMNodeType;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQObject;
import org.eclipse.core.runtime.CoreException;

public class QtPDOMQmlRegistration
extends QtPDOMBinding {
    private static int offsetInitializer = QtPDOMBinding.Field.Last.offset;

    public QtPDOMQmlRegistration(QtPDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public QtPDOMQmlRegistration(QtPDOMLinkage linkage, QmlTypeRegistration qmlTypeReg, IASTName cppName) throws CoreException {
        super(linkage, null, qmlTypeReg);
        this.putStringOrNull(Field.QObjectName.offset, qmlTypeReg.getQObjectName());
        this.putLongOrNull(Field.Version.offset, qmlTypeReg.getVersion());
        this.putStringOrNull(Field.Uri.offset, qmlTypeReg.getUri());
        this.putLongOrNull(Field.Major.offset, qmlTypeReg.getMajor());
        this.putLongOrNull(Field.Minor.offset, qmlTypeReg.getMinor());
        this.putStringOrNull(Field.QmlName.offset, qmlTypeReg.getQmlName());
    }

    public static Collection<QtPDOMQmlRegistration> findFor(QtPDOMQObject qobj) throws CoreException {
        PDOMLinkage linkage = qobj.getLinkage();
        if (linkage == null || !(linkage instanceof QtPDOMLinkage)) {
            return Collections.emptyList();
        }
        String name = qobj.getName();
        if (name == null) {
            return Collections.emptyList();
        }
        QtPDOMLinkage qtLinkage = (QtPDOMLinkage)linkage;
        return qtLinkage.getQmlRegistrations(qobj.getName());
    }

    @Override
    protected int getRecordSize() {
        return Field.Last.offset;
    }

    public int getNodeType() {
        return QtPDOMNodeType.QmlTypeRegistration.Type;
    }

    public String getQObjectName() throws CoreException {
        return this.getStringOrNull(Field.QObjectName.offset);
    }

    public Long getVersion() throws CoreException {
        return this.getLongOrNull(Field.Version.offset);
    }

    public Long getMajor() throws CoreException {
        return this.getLongOrNull(Field.Major.offset);
    }

    public Long getMinor() throws CoreException {
        return this.getLongOrNull(Field.Minor.offset);
    }

    public String getUri() throws CoreException {
        return this.getStringOrNull(Field.Uri.offset);
    }

    public String getQmlName() throws CoreException {
        return this.getStringOrNull(Field.QmlName.offset);
    }

    protected static enum Field {
        CppRecord(4),
        QObjectName(4),
        Version(8),
        Uri(4),
        Major(8),
        Minor(8),
        QmlName(4),
        Last(0);

        public final int offset = offsetInitializer;

        private Field(int sizeof) {
            offsetInitializer += sizeof;
        }
    }
}

