/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core.configure;

import org.eclipse.cdt.internal.autotools.core.configure.AbstractConfigurationOption;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;

public class VariableConfigureOption
extends AbstractConfigurationOption {
    private String value;

    public VariableConfigureOption(String name, AutotoolsConfiguration cfg) {
        super(name, cfg);
        this.value = "";
    }

    public VariableConfigureOption(String name, String transformedName, AutotoolsConfiguration autotoolsConfiguration) {
        super(name, transformedName, autotoolsConfiguration);
        this.value = "";
    }

    public VariableConfigureOption(String name, AutotoolsConfiguration cfg, String value) {
        super(name, cfg);
        this.value = value;
    }

    @Override
    public String getParameter() {
        if (this.isParmSet()) {
            return this.value;
        }
        return "";
    }

    @Override
    public boolean isParmSet() {
        return !this.value.isEmpty();
    }

    @Override
    public IConfigureOption copy(AutotoolsConfiguration cfg) {
        return new VariableConfigureOption(this.name, cfg, this.value);
    }

    @Override
    public void setValue(String newValue) {
        if (!newValue.equals(this.value)) {
            this.cfg.setDirty(true);
            this.value = newValue;
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getType() {
        return 8;
    }
}

