/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.common;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.net.UnknownServiceException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.SftpUniversalOwnerAndGroup;
import org.apache.sshd.sftp.server.DefaultGroupPrincipal;
import org.apache.sshd.sftp.server.InvalidHandleException;
import org.apache.sshd.sftp.server.UnixDateFormat;

public final class SftpHelper {
    public static final Map<Integer, String> DEFAULT_SUBSTATUS_MESSAGE;

    private SftpHelper() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static Boolean getEndOfFileIndicatorValue(Buffer buffer, int version) {
        return version < 6 || buffer.available() < 1 ? null : Boolean.valueOf(buffer.getBoolean());
    }

    public static Boolean getEndOfListIndicatorValue(Buffer buffer, int version) {
        return version < 6 || buffer.available() < 1 ? null : Boolean.valueOf(buffer.getBoolean());
    }

    public static Boolean indicateEndOfNamesList(Buffer buffer, int version, PropertyResolver resolver) {
        return SftpHelper.indicateEndOfNamesList(buffer, version, resolver, true);
    }

    public static Boolean indicateEndOfNamesList(Buffer buffer, int version, PropertyResolver resolver, boolean indicatorValue) {
        if (version < 6) {
            return null;
        }
        if (!((Boolean)SftpModuleProperties.APPEND_END_OF_LIST_INDICATOR.getRequired(resolver)).booleanValue()) {
            return null;
        }
        buffer.putBoolean(indicatorValue);
        return indicatorValue;
    }

    public static <B extends Buffer> B writeAttrs(B buffer, int version, Map<String, ?> attributes) {
        if (version == 3) {
            return SftpHelper.writeAttrsV3(buffer, version, attributes);
        }
        if (version >= 4) {
            return SftpHelper.writeAttrsV4(buffer, version, attributes);
        }
        throw new IllegalStateException("Unsupported SFTP version: " + version);
    }

    public static <B extends Buffer> B writeAttrsV3(B buffer, int version, Map<String, ?> attributes) {
        ValidateUtils.checkTrue((version == 3 ? 1 : 0) != 0, (String)"Illegal version: %d", (long)version);
        boolean isReg = SftpHelper.getBool((Boolean)attributes.get("isRegularFile"));
        boolean isDir = SftpHelper.getBool((Boolean)attributes.get("isDirectory"));
        boolean isLnk = SftpHelper.getBool((Boolean)attributes.get("isSymbolicLink"));
        Collection perms = (Collection)attributes.get("permissions");
        Number size = (Number)attributes.get("size");
        FileTime lastModifiedTime = (FileTime)attributes.get("lastModifiedTime");
        FileTime lastAccessTime = (FileTime)attributes.get("lastAccessTime");
        Map extensions = (Map)attributes.get("extended");
        int flags = ((isReg || isLnk) && size != null ? 1 : 0) | (attributes.containsKey("uid") && attributes.containsKey("gid") ? 2 : 0) | (perms != null ? 4 : 0) | (lastModifiedTime != null && lastAccessTime != null ? 8 : 0) | (extensions != null ? Integer.MIN_VALUE : 0);
        buffer.putInt((long)flags);
        if ((flags & 1) != 0) {
            buffer.putLong(size.longValue());
        }
        if ((flags & 2) != 0) {
            buffer.putInt((long)((Number)attributes.get("uid")).intValue());
            buffer.putInt((long)((Number)attributes.get("gid")).intValue());
        }
        if ((flags & 4) != 0) {
            buffer.putInt((long)SftpHelper.attributesToPermissions(isReg, isDir, isLnk, perms));
        }
        if ((flags & 8) != 0) {
            buffer = SftpHelper.writeTime(buffer, version, flags, lastAccessTime);
            buffer = SftpHelper.writeTime(buffer, version, flags, lastModifiedTime);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            buffer = SftpHelper.writeExtensions(buffer, extensions);
        }
        return buffer;
    }

    public static <B extends Buffer> B writeAttrsV4(B buffer, int version, Map<String, ?> attributes) {
        ValidateUtils.checkTrue((version >= 4 ? 1 : 0) != 0, (String)"Illegal version: %d", (long)version);
        boolean isReg = SftpHelper.getBool((Boolean)attributes.get("isRegularFile"));
        boolean isDir = SftpHelper.getBool((Boolean)attributes.get("isDirectory"));
        boolean isLnk = SftpHelper.getBool((Boolean)attributes.get("isSymbolicLink"));
        Collection perms = (Collection)attributes.get("permissions");
        Number size = (Number)attributes.get("size");
        FileTime lastModifiedTime = (FileTime)attributes.get("lastModifiedTime");
        FileTime lastAccessTime = (FileTime)attributes.get("lastAccessTime");
        FileTime creationTime = (FileTime)attributes.get("creationTime");
        Collection acl = (Collection)attributes.get("acl");
        Map extensions = (Map)attributes.get("extended");
        int flags = ((isReg || isLnk) && size != null ? 1 : 0) | (attributes.containsKey("owner") && attributes.containsKey("group") ? 128 : 0) | (perms != null ? 4 : 0) | (lastModifiedTime != null ? 32 : 0) | (creationTime != null ? 16 : 0) | (lastAccessTime != null ? 8 : 0) | (acl != null ? 64 : 0) | (extensions != null ? Integer.MIN_VALUE : 0);
        buffer.putInt((long)flags);
        buffer.putByte((byte)(isReg ? 1 : (isDir ? 2 : (isLnk ? 3 : 5))));
        if ((flags & 1) != 0) {
            buffer.putLong(size.longValue());
        }
        if ((flags & 0x80) != 0) {
            buffer.putString(Objects.toString(attributes.get("owner"), SftpUniversalOwnerAndGroup.Owner.getName()));
            buffer.putString(Objects.toString(attributes.get("group"), SftpUniversalOwnerAndGroup.Group.getName()));
        }
        if ((flags & 4) != 0) {
            buffer.putInt((long)SftpHelper.attributesToPermissions(isReg, isDir, isLnk, perms));
        }
        if ((flags & 8) != 0) {
            buffer = SftpHelper.writeTime(buffer, version, flags, lastAccessTime);
        }
        if ((flags & 0x10) != 0) {
            buffer = SftpHelper.writeTime(buffer, version, flags, creationTime);
        }
        if ((flags & 0x20) != 0) {
            buffer = SftpHelper.writeTime(buffer, version, flags, lastModifiedTime);
        }
        if ((flags & 0x40) != 0) {
            buffer = SftpHelper.writeACLs(buffer, version, acl);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            buffer = SftpHelper.writeExtensions(buffer, extensions);
        }
        return buffer;
    }

    public static <B extends Buffer> B writeAttributes(B buffer, SftpClient.Attributes attributes, int sftpVersion) {
        int flagsMask = 0;
        Set<SftpClient.Attribute> flags = Objects.requireNonNull(attributes, "No attributes").getFlags();
        if (sftpVersion == 3) {
            for (SftpClient.Attribute a : flags) {
                switch (a) {
                    case Size: {
                        flagsMask |= 1;
                        break;
                    }
                    case UidGid: {
                        flagsMask |= 2;
                        break;
                    }
                    case Perms: {
                        flagsMask |= 4;
                        break;
                    }
                    case AccessTime: {
                        if (!flags.contains((Object)SftpClient.Attribute.ModifyTime)) break;
                        flagsMask |= 8;
                        break;
                    }
                    case ModifyTime: {
                        if (!flags.contains((Object)SftpClient.Attribute.AccessTime)) break;
                        flagsMask |= 8;
                        break;
                    }
                    case Extensions: {
                        flagsMask |= Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            buffer.putInt((long)flagsMask);
            if ((flagsMask & 1) != 0) {
                buffer.putLong(attributes.getSize());
            }
            if ((flagsMask & 2) != 0) {
                buffer.putInt((long)attributes.getUserId());
                buffer.putInt((long)attributes.getGroupId());
            }
            if ((flagsMask & 4) != 0) {
                buffer.putInt((long)attributes.getPermissions());
            }
            if ((flagsMask & 8) != 0) {
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes.getAccessTime());
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes.getModifyTime());
            }
        } else if (sftpVersion >= 4) {
            for (SftpClient.Attribute a : flags) {
                switch (a) {
                    case Size: {
                        flagsMask |= 1;
                        break;
                    }
                    case OwnerGroup: {
                        String owner = attributes.getOwner();
                        String group = attributes.getGroup();
                        if (!GenericUtils.isNotEmpty((CharSequence)owner) || !GenericUtils.isNotEmpty((CharSequence)group)) break;
                        flagsMask |= 0x80;
                        break;
                    }
                    case Perms: {
                        flagsMask |= 4;
                        break;
                    }
                    case AccessTime: {
                        flagsMask |= 8;
                        break;
                    }
                    case ModifyTime: {
                        flagsMask |= 0x20;
                        break;
                    }
                    case CreateTime: {
                        flagsMask |= 0x10;
                        break;
                    }
                    case Acl: {
                        flagsMask |= 0x40;
                        break;
                    }
                    case Extensions: {
                        flagsMask |= Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            buffer.putInt((long)flagsMask);
            buffer.putByte((byte)attributes.getType());
            if ((flagsMask & 1) != 0) {
                buffer.putLong(attributes.getSize());
            }
            if ((flagsMask & 0x80) != 0) {
                String owner = attributes.getOwner();
                buffer.putString(owner);
                String group = attributes.getGroup();
                buffer.putString(group);
            }
            if ((flagsMask & 4) != 0) {
                buffer.putInt((long)attributes.getPermissions());
            }
            if ((flagsMask & 8) != 0) {
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes.getAccessTime());
            }
            if ((flagsMask & 0x10) != 0) {
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes.getCreateTime());
            }
            if ((flagsMask & 0x20) != 0) {
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes.getModifyTime());
            }
            if ((flagsMask & 0x40) != 0) {
                buffer = SftpHelper.writeACLs(buffer, sftpVersion, attributes.getAcl());
            }
        } else {
            throw new UnsupportedOperationException("writeAttributes(" + attributes + ") unsupported version: " + sftpVersion);
        }
        if ((flagsMask & Integer.MIN_VALUE) != 0) {
            buffer = SftpHelper.writeExtensions(buffer, attributes.getExtensions());
        }
        return buffer;
    }

    public static boolean getBool(Boolean bool) {
        return bool != null && bool != false;
    }

    public static int attributesToPermissions(boolean isReg, boolean isDir, boolean isLnk, Collection<PosixFilePermission> perms) {
        int pf = 0;
        if (perms != null) {
            for (PosixFilePermission p : perms) {
                switch (p) {
                    case OWNER_READ: {
                        pf |= 0x100;
                        break;
                    }
                    case OWNER_WRITE: {
                        pf |= 0x80;
                        break;
                    }
                    case OWNER_EXECUTE: {
                        pf |= 0x40;
                        break;
                    }
                    case GROUP_READ: {
                        pf |= 0x20;
                        break;
                    }
                    case GROUP_WRITE: {
                        pf |= 0x10;
                        break;
                    }
                    case GROUP_EXECUTE: {
                        pf |= 8;
                        break;
                    }
                    case OTHERS_READ: {
                        pf |= 4;
                        break;
                    }
                    case OTHERS_WRITE: {
                        pf |= 2;
                        break;
                    }
                    case OTHERS_EXECUTE: {
                        pf |= 1;
                        break;
                    }
                }
            }
        }
        pf |= isReg ? 32768 : 0;
        pf |= isDir ? 16384 : 0;
        return pf |= isLnk ? 40960 : 0;
    }

    public static int permissionsToFileType(int perms) {
        if ((0xA000 & perms) == 40960) {
            return 3;
        }
        if ((0x8000 & perms) == 32768) {
            return 1;
        }
        if ((0x4000 & perms) == 16384) {
            return 2;
        }
        if ((0xC000 & perms) == 49152) {
            return 6;
        }
        if ((0x6000 & perms) == 24576) {
            return 8;
        }
        if ((0x2000 & perms) == 8192) {
            return 7;
        }
        if ((0x1000 & perms) == 4096) {
            return 9;
        }
        return 5;
    }

    public static int fileTypeToPermission(int type) {
        switch (type) {
            case 1: {
                return 32768;
            }
            case 2: {
                return 16384;
            }
            case 3: {
                return 40960;
            }
            case 6: {
                return 49152;
            }
            case 8: {
                return 24576;
            }
            case 7: {
                return 8192;
            }
            case 9: {
                return 4096;
            }
        }
        return 0;
    }

    public static Set<PosixFilePermission> permissionsToAttributes(int perms) {
        EnumSet<PosixFilePermission> p = EnumSet.noneOf(PosixFilePermission.class);
        if ((perms & 0x100) != 0) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) != 0) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) != 0) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) != 0) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) != 0) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) != 0) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) != 0) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) != 0) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) != 0) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }

    public static int resolveSubstatus(Throwable t) {
        if (t instanceof NoSuchFileException || t instanceof FileNotFoundException) {
            return 2;
        }
        if (t instanceof InvalidHandleException) {
            return 9;
        }
        if (t instanceof FileAlreadyExistsException) {
            return 11;
        }
        if (t instanceof DirectoryNotEmptyException) {
            return 18;
        }
        if (t instanceof NotDirectoryException) {
            return 19;
        }
        if (t instanceof AccessDeniedException) {
            return 3;
        }
        if (t instanceof EOFException) {
            return 1;
        }
        if (t instanceof OverlappingFileLockException) {
            return 17;
        }
        if (t instanceof UnsupportedOperationException || t instanceof UnknownServiceException) {
            return 8;
        }
        if (t instanceof InvalidPathException) {
            return 20;
        }
        if (t instanceof IllegalArgumentException) {
            return 23;
        }
        if (t instanceof UserPrincipalNotFoundException) {
            return 16;
        }
        if (t instanceof FileSystemLoopException) {
            return 21;
        }
        if (t instanceof SftpException) {
            return ((SftpException)t).getStatus();
        }
        return 4;
    }

    public static String resolveStatusMessage(int subStatus) {
        String message = DEFAULT_SUBSTATUS_MESSAGE.get(subStatus);
        return GenericUtils.isEmpty((CharSequence)message) ? "Unknown error: " + subStatus : message;
    }

    public static NavigableMap<String, Object> readAttrs(Buffer buffer, int version) {
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        int flags = buffer.getInt();
        if (version >= 4) {
            int type = buffer.getUByte();
            switch (type) {
                case 1: {
                    attrs.put("isRegularFile", Boolean.TRUE);
                    break;
                }
                case 2: {
                    attrs.put("isDirectory", Boolean.TRUE);
                    break;
                }
                case 3: {
                    attrs.put("isSymbolicLink", Boolean.TRUE);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    attrs.put("isOther", Boolean.TRUE);
                    break;
                }
            }
        }
        if ((flags & 1) != 0) {
            attrs.put("size", buffer.getLong());
        }
        if (version == 3) {
            if ((flags & 2) != 0) {
                attrs.put("uid", buffer.getInt());
                attrs.put("gid", buffer.getInt());
            }
        } else {
            if (version >= 6 && (flags & 0x400) != 0) {
                long type = buffer.getLong();
            }
            if ((flags & 0x80) != 0) {
                attrs.put("owner", new DefaultGroupPrincipal(buffer.getString()));
                attrs.put("group", new DefaultGroupPrincipal(buffer.getString()));
            }
        }
        if ((flags & 4) != 0) {
            attrs.put("permissions", SftpHelper.permissionsToAttributes(buffer.getInt()));
        }
        if (version == 3) {
            if ((flags & 8) != 0) {
                attrs.put("lastAccessTime", SftpHelper.readTime(buffer, version, flags));
                attrs.put("lastModifiedTime", SftpHelper.readTime(buffer, version, flags));
            }
        } else if (version >= 4) {
            if ((flags & 8) != 0) {
                attrs.put("lastAccessTime", SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x10) != 0) {
                attrs.put("creationTime", SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x20) != 0) {
                attrs.put("lastModifiedTime", SftpHelper.readTime(buffer, version, flags));
            }
            if (version >= 6 && (flags & 0x8000) != 0) {
                attrs.put("ctime", SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x40) != 0) {
                attrs.put("acl", SftpHelper.readACLs(buffer, version));
            }
            if ((flags & 0x200) != 0) {
                int bits = buffer.getInt();
                int valid = -1;
                if (version >= 6) {
                    valid = buffer.getInt();
                }
            }
            if (version >= 6) {
                if ((flags & 0x800) != 0) {
                    boolean bl = buffer.getBoolean();
                }
                if ((flags & 0x1000) != 0) {
                    String string = buffer.getString();
                }
                if ((flags & 0x2000) != 0) {
                    int n = buffer.getInt();
                }
                if ((flags & 0x4000) != 0) {
                    String string = buffer.getString();
                }
            }
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            attrs.put("extended", SftpHelper.readExtensions(buffer));
        }
        return attrs;
    }

    public static NavigableMap<String, byte[]> readExtensions(Buffer buffer) {
        int count = buffer.getInt();
        if (count < 0 || count > 32768) {
            throw new IndexOutOfBoundsException("Illogical extensions count: " + count);
        }
        TreeMap<String, byte[]> extended = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 1; i <= count; ++i) {
            byte[] val;
            String key = buffer.getString();
            byte[] prev = extended.put(key, val = buffer.getBytes());
            ValidateUtils.checkTrue((prev == null ? 1 : 0) != 0, (String)"Duplicate values for extended key=%s", (Object)key);
        }
        return extended;
    }

    public static <B extends Buffer> B writeExtensions(B buffer, Map<?, ?> extensions) {
        int numExtensions = MapEntryUtils.size(extensions);
        buffer.putInt((long)numExtensions);
        if (numExtensions <= 0) {
            return buffer;
        }
        for (Map.Entry<?, ?> ee : extensions.entrySet()) {
            Object key = Objects.requireNonNull(ee.getKey(), "No extension type");
            Object value = Objects.requireNonNull(ee.getValue(), "No extension value");
            buffer.putString(key.toString());
            if (value instanceof byte[]) {
                buffer.putBytes((byte[])value);
                continue;
            }
            buffer.putString(value.toString());
        }
        return buffer;
    }

    public static NavigableMap<String, String> toStringExtensions(Map<String, ?> extensions) {
        if (MapEntryUtils.isEmpty(extensions)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ?> ee : extensions.entrySet()) {
            String key = Objects.requireNonNull(ee.getKey(), "No extension type");
            Object value = ValidateUtils.checkNotNull(ee.getValue(), (String)"No value for extension=%s", (Object)key);
            String prev = map.put(key.toString(), value instanceof byte[] ? new String((byte[])value, StandardCharsets.UTF_8) : value.toString());
            ValidateUtils.checkTrue((prev == null ? 1 : 0) != 0, (String)"Multiple values for extension=%s", (Object)key);
        }
        return map;
    }

    public static NavigableMap<String, byte[]> toBinaryExtensions(Map<String, String> extensions) {
        if (MapEntryUtils.isEmpty(extensions)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, byte[]> map = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
        extensions.forEach((key, value) -> {
            ValidateUtils.checkNotNull((Object)value, (String)"No value for extension=%s", (Object)key);
            byte[] prev = map.put((String)key, value.getBytes(StandardCharsets.UTF_8));
            ValidateUtils.checkTrue((prev == null ? 1 : 0) != 0, (String)"Multiple values for extension=%s", (Object)key);
        });
        return map;
    }

    public static List<AclEntry> readACLs(Buffer buffer, int version) {
        int aclSize = buffer.getInt();
        if (aclSize < 0 || aclSize > 65536) {
            throw new IndexOutOfBoundsException("Illogical ACL entries size: " + aclSize);
        }
        int startPos = buffer.rpos();
        ByteArrayBuffer aclBuffer = new ByteArrayBuffer(buffer.array(), startPos, aclSize, true);
        List<AclEntry> acl = SftpHelper.decodeACLs((Buffer)aclBuffer, version);
        buffer.rpos(startPos + aclSize);
        return acl;
    }

    public static List<AclEntry> decodeACLs(Buffer buffer, int version) {
        int count;
        int aclFlags = 0;
        if (version >= 6) {
            aclFlags = buffer.getInt();
        }
        if ((count = buffer.getInt()) < 0 || count > 32768) {
            throw new IndexOutOfBoundsException("Illogical ACL entries count: " + count);
        }
        ValidateUtils.checkTrue((count >= 0 ? 1 : 0) != 0, (String)"Invalid ACL entries count: %d", (long)count);
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<AclEntry> acls = new ArrayList<AclEntry>(count);
        for (int i = 1; i <= count; ++i) {
            int aclType = buffer.getInt();
            int aclFlag = buffer.getInt();
            int aclMask = buffer.getInt();
            String aclWho = buffer.getString();
            acls.add(SftpHelper.buildAclEntry(aclType, aclFlag, aclMask, aclWho));
        }
        return acls;
    }

    public static AclEntry buildAclEntry(int aclType, int aclFlag, int aclMask, String aclWho) {
        DefaultGroupPrincipal who = new DefaultGroupPrincipal(aclWho);
        return AclEntry.newBuilder().setType((AclEntryType)((Object)ValidateUtils.checkNotNull((Object)((Object)SftpHelper.decodeAclEntryType(aclType)), (String)"Unknown ACL type: %d", (long)aclType))).setFlags(SftpHelper.decodeAclFlags(aclFlag)).setPermissions(SftpHelper.decodeAclMask(aclMask)).setPrincipal(who).build();
    }

    public static AclEntryType decodeAclEntryType(int aclType) {
        switch (aclType) {
            case 0: {
                return AclEntryType.ALLOW;
            }
            case 1: {
                return AclEntryType.DENY;
            }
            case 2: {
                return AclEntryType.AUDIT;
            }
            case 3: {
                return AclEntryType.ALARM;
            }
        }
        return null;
    }

    public static Set<AclEntryFlag> decodeAclFlags(int aclFlag) {
        EnumSet<AclEntryFlag> flags = EnumSet.noneOf(AclEntryFlag.class);
        if ((aclFlag & 1) != 0) {
            flags.add(AclEntryFlag.FILE_INHERIT);
        }
        if ((aclFlag & 2) != 0) {
            flags.add(AclEntryFlag.DIRECTORY_INHERIT);
        }
        if ((aclFlag & 4) != 0) {
            flags.add(AclEntryFlag.NO_PROPAGATE_INHERIT);
        }
        if ((aclFlag & 8) != 0) {
            flags.add(AclEntryFlag.INHERIT_ONLY);
        }
        return flags;
    }

    public static Set<AclEntryPermission> decodeAclMask(int aclMask) {
        EnumSet<AclEntryPermission> mask = EnumSet.noneOf(AclEntryPermission.class);
        if ((aclMask & 1) != 0) {
            mask.add(AclEntryPermission.READ_DATA);
        }
        if ((aclMask & 1) != 0) {
            mask.add(AclEntryPermission.LIST_DIRECTORY);
        }
        if ((aclMask & 2) != 0) {
            mask.add(AclEntryPermission.WRITE_DATA);
        }
        if ((aclMask & 2) != 0) {
            mask.add(AclEntryPermission.ADD_FILE);
        }
        if ((aclMask & 4) != 0) {
            mask.add(AclEntryPermission.APPEND_DATA);
        }
        if ((aclMask & 4) != 0) {
            mask.add(AclEntryPermission.ADD_SUBDIRECTORY);
        }
        if ((aclMask & 8) != 0) {
            mask.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if ((aclMask & 0x10) != 0) {
            mask.add(AclEntryPermission.WRITE_NAMED_ATTRS);
        }
        if ((aclMask & 0x20) != 0) {
            mask.add(AclEntryPermission.EXECUTE);
        }
        if ((aclMask & 0x40) != 0) {
            mask.add(AclEntryPermission.DELETE_CHILD);
        }
        if ((aclMask & 0x80) != 0) {
            mask.add(AclEntryPermission.READ_ATTRIBUTES);
        }
        if ((aclMask & 0x100) != 0) {
            mask.add(AclEntryPermission.WRITE_ATTRIBUTES);
        }
        if ((aclMask & 0x10000) != 0) {
            mask.add(AclEntryPermission.DELETE);
        }
        if ((aclMask & 0x20000) != 0) {
            mask.add(AclEntryPermission.READ_ACL);
        }
        if ((aclMask & 0x40000) != 0) {
            mask.add(AclEntryPermission.WRITE_ACL);
        }
        if ((aclMask & 0x80000) != 0) {
            mask.add(AclEntryPermission.WRITE_OWNER);
        }
        if ((aclMask & 0x100000) != 0) {
            mask.add(AclEntryPermission.SYNCHRONIZE);
        }
        return mask;
    }

    public static <B extends Buffer> B writeACLs(B buffer, int version, Collection<? extends AclEntry> acl) {
        int lenPos = buffer.wpos();
        buffer.putInt(0L);
        buffer = SftpHelper.encodeACLs(buffer, version, acl);
        BufferUtils.updateLengthPlaceholder(buffer, (int)lenPos);
        return buffer;
    }

    public static <B extends Buffer> B encodeACLs(B buffer, int version, Collection<? extends AclEntry> acl) {
        Objects.requireNonNull(acl, "No ACL");
        if (version >= 6) {
            buffer.putInt(0L);
        }
        int numEntries = GenericUtils.size(acl);
        buffer.putInt((long)numEntries);
        if (numEntries > 0) {
            for (AclEntry aclEntry : acl) {
                buffer = SftpHelper.writeAclEntry(buffer, aclEntry);
            }
        }
        return buffer;
    }

    public static <B extends Buffer> B writeAclEntry(B buffer, AclEntry acl) {
        Objects.requireNonNull(acl, "No ACL");
        AclEntryType type = acl.type();
        int aclType = SftpHelper.encodeAclEntryType(type);
        ValidateUtils.checkTrue((aclType >= 0 ? 1 : 0) != 0, (String)"Unknown ACL type: %s", (Object)((Object)type));
        buffer.putInt((long)aclType);
        buffer.putInt(SftpHelper.encodeAclFlags(acl.flags()));
        buffer.putInt(SftpHelper.encodeAclMask(acl.permissions()));
        UserPrincipal user = acl.principal();
        buffer.putString(user.getName());
        return buffer;
    }

    public static int encodeAclEntryType(AclEntryType type) {
        if (type == null) {
            return Integer.MIN_VALUE;
        }
        switch (type) {
            case ALARM: {
                return 3;
            }
            case ALLOW: {
                return 0;
            }
            case AUDIT: {
                return 2;
            }
            case DENY: {
                return 1;
            }
        }
        return -1;
    }

    public static long encodeAclFlags(Collection<AclEntryFlag> flags) {
        if (GenericUtils.isEmpty(flags)) {
            return 0L;
        }
        long aclFlag = 0L;
        if (flags.contains((Object)AclEntryFlag.FILE_INHERIT)) {
            aclFlag |= 1L;
        }
        if (flags.contains((Object)AclEntryFlag.DIRECTORY_INHERIT)) {
            aclFlag |= 2L;
        }
        if (flags.contains((Object)AclEntryFlag.NO_PROPAGATE_INHERIT)) {
            aclFlag |= 4L;
        }
        if (flags.contains((Object)AclEntryFlag.INHERIT_ONLY)) {
            aclFlag |= 8L;
        }
        return aclFlag;
    }

    public static long encodeAclMask(Collection<AclEntryPermission> mask) {
        if (GenericUtils.isEmpty(mask)) {
            return 0L;
        }
        long aclMask = 0L;
        if (mask.contains((Object)AclEntryPermission.READ_DATA)) {
            aclMask |= 1L;
        }
        if (mask.contains((Object)AclEntryPermission.LIST_DIRECTORY)) {
            aclMask |= 1L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_DATA)) {
            aclMask |= 2L;
        }
        if (mask.contains((Object)AclEntryPermission.ADD_FILE)) {
            aclMask |= 2L;
        }
        if (mask.contains((Object)AclEntryPermission.APPEND_DATA)) {
            aclMask |= 4L;
        }
        if (mask.contains((Object)AclEntryPermission.ADD_SUBDIRECTORY)) {
            aclMask |= 4L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_NAMED_ATTRS)) {
            aclMask |= 8L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_NAMED_ATTRS)) {
            aclMask |= 0x10L;
        }
        if (mask.contains((Object)AclEntryPermission.EXECUTE)) {
            aclMask |= 0x20L;
        }
        if (mask.contains((Object)AclEntryPermission.DELETE_CHILD)) {
            aclMask |= 0x40L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_ATTRIBUTES)) {
            aclMask |= 0x80L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_ATTRIBUTES)) {
            aclMask |= 0x100L;
        }
        if (mask.contains((Object)AclEntryPermission.DELETE)) {
            aclMask |= 0x10000L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_ACL)) {
            aclMask |= 0x20000L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_ACL)) {
            aclMask |= 0x40000L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_OWNER)) {
            aclMask |= 0x80000L;
        }
        if (mask.contains((Object)AclEntryPermission.SYNCHRONIZE)) {
            aclMask |= 0x100000L;
        }
        return aclMask;
    }

    public static <B extends Buffer> B writeTime(B buffer, int version, int flags, FileTime time) {
        if (version >= 4) {
            buffer.putLong(time.to(TimeUnit.SECONDS));
            if ((flags & 0x100) != 0) {
                buffer.putInt((long)time.toInstant().getNano());
            }
        } else {
            buffer.putInt(time.to(TimeUnit.SECONDS));
        }
        return buffer;
    }

    public static FileTime readTime(Buffer buffer, int version, int flags) {
        long secs;
        if (version >= 4) {
            long nanos;
            secs = buffer.getLong();
            if ((flags & 0x100) != 0 && (nanos = buffer.getUInt()) != 0L) {
                try {
                    return FileTime.from(Instant.ofEpochSecond(secs, nanos));
                }
                catch (ArithmeticException | DateTimeException runtimeException) {}
            }
        } else {
            secs = buffer.getUInt();
        }
        return FileTime.from(secs, TimeUnit.SECONDS);
    }

    public static String getLongName(String shortName, Map<String, ?> attributes) {
        int index;
        Number length;
        String owner = Objects.toString(attributes.get("owner"), null);
        String username = OsUtils.getCanonicalUser((String)owner);
        if (GenericUtils.isEmpty((CharSequence)username)) {
            username = SftpUniversalOwnerAndGroup.Owner.getName();
        }
        String group = Objects.toString(attributes.get("group"), null);
        if (GenericUtils.isEmpty((CharSequence)(group = OsUtils.resolveCanonicalGroup((String)group, (String)owner)))) {
            group = SftpUniversalOwnerAndGroup.Group.getName();
        }
        if ((length = (Number)attributes.get("size")) == null) {
            length = 0L;
        }
        String lengthString = String.format("%1$8s", length);
        String linkCount = Objects.toString(attributes.get("nlink"), null);
        if (GenericUtils.isEmpty((CharSequence)linkCount)) {
            linkCount = "1";
        }
        Boolean isDirectory = (Boolean)attributes.get("isDirectory");
        Boolean isLink = (Boolean)attributes.get("isSymbolicLink");
        EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)attributes.get("permissions");
        if (perms == null) {
            perms = EnumSet.noneOf(PosixFilePermission.class);
        }
        String permsString = PosixFilePermissions.toString((Set<PosixFilePermission>)perms);
        String timeStamp = UnixDateFormat.getUnixDate((FileTime)attributes.get("lastModifiedTime"));
        StringBuilder sb = new StringBuilder(GenericUtils.length((CharSequence)linkCount) + GenericUtils.length((CharSequence)username) + GenericUtils.length((CharSequence)group) + GenericUtils.length((CharSequence)timeStamp) + GenericUtils.length((CharSequence)lengthString) + GenericUtils.length((CharSequence)permsString) + GenericUtils.length((CharSequence)shortName) + 32);
        sb.append((char)(SftpHelper.getBool(isDirectory) ? 100 : (SftpHelper.getBool(isLink) ? 108 : 45))).append(permsString);
        sb.append(' ');
        for (index = linkCount.length(); index < 3; ++index) {
            sb.append(' ');
        }
        sb.append(linkCount);
        sb.append(' ').append(username);
        for (index = username.length(); index < 8; ++index) {
            sb.append(' ');
        }
        sb.append(' ').append(group);
        for (index = group.length(); index < 8; ++index) {
            sb.append(' ');
        }
        sb.append(' ').append(lengthString).append(' ').append(timeStamp).append(' ').append(shortName);
        return sb.toString();
    }

    static {
        TreeMap map = new TreeMap(Comparator.naturalOrder());
        map.put(0, "Success");
        map.put(1, "End of file");
        map.put(2, "No such file or directory");
        map.put(3, "Permission denied");
        map.put(4, "General failure");
        map.put(5, "Bad message data");
        map.put(6, "No connection to server");
        map.put(7, "Connection lost");
        map.put(8, "Unsupported operation requested");
        map.put(9, "Invalid handle value");
        map.put(10, "No such path");
        map.put(11, "File/Directory already exists");
        map.put(12, "File/Directory is write-protected");
        map.put(13, "No such meadia");
        map.put(14, "No space left on device");
        map.put(15, "Quota exceeded");
        map.put(16, "Unknown user/group");
        map.put(17, "Lock conflict");
        map.put(18, "Directory not empty");
        map.put(19, "Accessed location is not a directory");
        map.put(20, "Invalid filename");
        map.put(21, "Link loop");
        map.put(22, "Cannot remove");
        map.put(23, "Invalid parameter");
        map.put(24, "Accessed location is a directory");
        map.put(25, "Range lock conflict");
        map.put(26, "Range lock refused");
        map.put(27, "Delete pending");
        map.put(28, "Corrupted file/directory");
        map.put(29, "Invalid file/directory owner");
        map.put(30, "Invalid file/directory group");
        map.put(31, "No matching byte range lock");
        DEFAULT_SUBSTATUS_MESSAGE = Collections.unmodifiableMap(map);
    }
}

