/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.internal.transport.SocketWrapper;
import org.eclipse.wst.jsdt.chromium.internal.websocket.HandshakeUtil;

class Hybi00Handshake {
    private static final Set<String> EXPECTED_FIELDS = new HashSet<String>(Arrays.asList("upgrade", "connection", "sec-websocket-origin", "sec-websocket-location"));

    Hybi00Handshake() {
    }

    static void performHandshake(SocketWrapper socket, InetSocketAddress endpoint, String resourceName, String origin, Random random) throws IOException {
        MessageDigest digest;
        HandshakeUtil.checkOriginString(origin);
        OutputStream output = ((SocketWrapper.LoggableOutputStream)socket.getLoggableOutput()).getOutputStream();
        OutputStreamWriter outputWriter = new OutputStreamWriter(output, HandshakeUtil.UTF_8_CHARSET);
        outputWriter.write("GET " + resourceName + " HTTP/1.1\r\n");
        ArrayList<String> fields = HandshakeUtil.createHttpFields(endpoint);
        fields.add("Upgrade: WebSocket");
        fields.add("Origin: " + origin);
        int port = endpoint.getPort();
        String portSuffix = port == 80 ? "" : ":" + port;
        fields.add("Host: " + endpoint.getHostName() + portSuffix);
        WsKey key1 = new WsKey(random);
        WsKey key2 = new WsKey(random);
        fields.add("Sec-WebSocket-Key1: " + key1.getKeySocketField());
        fields.add("Sec-WebSocket-Key2: " + key2.getKeySocketField());
        Collections.shuffle(fields, random);
        for (String field : fields) {
            outputWriter.write(field);
            outputWriter.write("\r\n");
        }
        outputWriter.write("\r\n");
        byte[] key3 = new byte[8];
        random.nextBytes(key3);
        ((Writer)outputWriter).flush();
        output.write(key3);
        output.flush();
        ByteArrayOutputStream challengeBytes = new ByteArrayOutputStream(16);
        Hybi00Handshake.writeIntBigEndian(key1.getNumber(), challengeBytes);
        Hybi00Handshake.writeIntBigEndian(key2.getNumber(), challengeBytes);
        challengeBytes.write(key3);
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] expectedMd5Bytes = digest.digest(challengeBytes.toByteArray());
        InputStream input = ((SocketWrapper.LoggableInputStream)socket.getLoggableInput()).getInputStream();
        HandshakeUtil.LineReader lineReader = HandshakeUtil.createLineReader(input);
        HandshakeUtil.HttpResponse httpResponse = HandshakeUtil.readHttpResponse(lineReader);
        if (httpResponse.getCode() != 101) {
            throw new IOException("Unexpected response code " + httpResponse.getCode());
        }
        Map<String, String> responseFields = httpResponse.getFields();
        if (responseFields.size() != EXPECTED_FIELDS.size()) {
            throw new IOException("Malformed response");
        }
        if (!responseFields.keySet().containsAll(EXPECTED_FIELDS)) {
            throw new IOException("Malformed response");
        }
        if (!"WebSocket".equals(responseFields.get("upgrade"))) {
            throw new IOException("Malformed response");
        }
        if (!"upgrade".equalsIgnoreCase(responseFields.get("connection"))) {
            throw new IOException("Malformed response");
        }
        if (!origin.equals(responseFields.get("sec-websocket-origin"))) {
            throw new IOException("Malformed response");
        }
        String expectedUrl = Hybi00Handshake.createUrl(endpoint, resourceName, false);
        if (!expectedUrl.equals(responseFields.get("sec-websocket-location"))) {
            throw new IOException("Malformed response: unexpected sec-websocket-location");
        }
        byte[] actualMd5Bytes = new byte[16];
        int readPos = 0;
        while (readPos < actualMd5Bytes.length) {
            int readRes = input.read(actualMd5Bytes, readPos, actualMd5Bytes.length - readPos);
            if (readRes == -1) {
                throw new IOException("End of stream");
            }
            readPos += readRes;
        }
        if (!Arrays.equals(expectedMd5Bytes, actualMd5Bytes)) {
            throw new IOException("Wrong challenge response: expected=" + Arrays.toString(expectedMd5Bytes) + " recieved=" + Arrays.toString(actualMd5Bytes));
        }
    }

    private static String createUrl(InetSocketAddress endpoint, String resourceName, boolean secure) {
        boolean needPort = secure ? endpoint.getPort() != 443 : endpoint.getPort() != 80;
        return String.valueOf(secure ? "wss://" : "ws://") + endpoint.getHostName() + (needPort ? ":" + endpoint.getPort() : "") + resourceName;
    }

    private static void writeIntBigEndian(long value, OutputStream output) throws IOException {
        output.write((byte)((value & 0xFF000000L) >> 24));
        output.write((byte)((value & 0xFF0000L) >> 16));
        output.write((byte)((value & 0xFF00L) >> 8));
        output.write((byte)(value & 0xFFL));
    }

    private static class WsKey {
        private static final long SPEC_MAX = 0xFFFFFFFFL;
        private final long resNumber;
        private final String keyString;

        WsKey(Random random) {
            long number;
            int spaces = random.nextInt(12) + 1;
            long max = 0xFFFFFFFFL / (long)spaces;
            this.resNumber = number = Math.abs(random.nextLong()) % (max + 1L);
            long product = number * (long)spaces;
            assert (product <= 0xFFFFFFFFL);
            String productStr = Long.toString(product);
            ArrayList<Byte> keyBytes = new ArrayList<Byte>(40);
            keyBytes.addAll(Collections.nCopies(productStr.length(), (byte)49));
            int stuffByteNumber = random.nextInt(12) + 1;
            int i = 0;
            while (i < stuffByteNumber) {
                keyBytes.add(StuffBytes.getByte(random));
                ++i;
            }
            Collections.shuffle(keyBytes, random);
            keyBytes.subList(0, keyBytes.size() - 1).addAll(Collections.nCopies(spaces, (byte)32));
            Collections.shuffle(keyBytes.subList(1, keyBytes.size() - 1), random);
            byte[] resultBytes = new byte[keyBytes.size()];
            int strPos = 0;
            int i2 = 0;
            while (i2 < resultBytes.length) {
                byte b = (Byte)keyBytes.get(i2);
                if (b == 49) {
                    b = (byte)productStr.charAt(strPos);
                    ++strPos;
                }
                resultBytes[i2] = b;
                ++i2;
            }
            assert (strPos == productStr.length());
            this.keyString = new String(resultBytes, HandshakeUtil.ASCII_CHARSET);
        }

        String getKeySocketField() {
            return this.keyString;
        }

        long getNumber() {
            return this.resNumber;
        }

        private static class StuffBytes {
            private static byte RANGE_1_BEGIN = (byte)33;
            private static byte RANGE_1_END = (byte)48;
            private static byte RANGE_2_BEGIN = (byte)58;
            private static byte RANGE_2_END = (byte)127;
            private static int RANDOM_RANGE_1 = RANGE_1_END - RANGE_1_BEGIN;
            private static int RANDOM_RANGE = RANDOM_RANGE_1 + RANGE_2_END - RANGE_2_BEGIN;

            private StuffBytes() {
            }

            private static byte getByte(Random random) {
                int i = random.nextInt(RANDOM_RANGE);
                if (i < RANDOM_RANGE_1) {
                    return (byte)(i + RANGE_1_BEGIN);
                }
                return (byte)(i + -RANDOM_RANGE_1 + RANGE_2_BEGIN);
            }
        }
    }
}

