/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation.factory;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.AbstractFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;

public final class ImplicitFactoryCreationSupport
extends AbstractFactoryCreationSupport {
    private final String m_signature;
    private JavaInfo m_invocationTarget;
    private String m_invocationSource;

    public ImplicitFactoryCreationSupport(MethodDescription description, MethodInvocation invocation) {
        super(description, invocation);
        this.m_signature = description.getSignature();
    }

    public ImplicitFactoryCreationSupport(String signature, String invocationSource) {
        this(null, signature, invocationSource);
    }

    public ImplicitFactoryCreationSupport(JavaInfo invocationTarget, String signature, String invocationSource) {
        this.m_invocationTarget = invocationTarget;
        this.m_signature = signature;
        this.m_invocationSource = invocationSource;
    }

    public String toString() {
        return "implicit-factory";
    }

    @Override
    public boolean canReorder() {
        return true;
    }

    @Override
    public String add_getSource(NodeTarget target) throws Exception {
        if (this.m_invocationTarget != null) {
            return TemplateUtils.format("{0}.{1}", new Object[]{this.m_invocationTarget, this.m_invocationSource});
        }
        return TemplateUtils.format("%parent%.{0}", this.m_invocationSource);
    }

    @Override
    public void add_setSourceExpression(Expression expression) throws Exception {
        this.m_invocation = (MethodInvocation)expression;
        this.m_javaInfo.bindToExpression((Expression)this.m_invocation);
        Expression targetExpression = this.m_invocation.getExpression();
        JavaInfo target = this.m_javaInfo.getRootJava().getChildRepresentedBy((ASTNode)targetExpression);
        this.m_description = target.getDescription().getMethod(this.m_signature);
    }

    @Override
    public Association getAssociation() throws Exception {
        return new InvocationVoidAssociation();
    }

    @Override
    public IClipboardCreationSupport getClipboard() throws Exception {
        if (!this.m_javaInfo.getParentJava().isRepresentedBy((ASTNode)this.m_invocation.getExpression())) {
            return null;
        }
        final String signature = this.m_signature;
        final String source = this.getClipboardSource();
        return new IClipboardCreationSupport(){
            private static final long serialVersionUID = 0L;

            @Override
            public CreationSupport create(JavaInfo rootObject) throws Exception {
                return new ImplicitFactoryCreationSupport(null, signature, source);
            }
        };
    }

    private String getClipboardSource() throws Exception {
        String argumentsSource = this.m_utils.getClipboardArguments(this.m_description.getParameters());
        return String.valueOf(this.m_description.getName()) + "(" + argumentsSource + ")";
    }
}

