/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.dialect;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.lang.ref.SoftReference;
import java.util.function.Function;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.business.internal.dialect.ErrorMessageProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;

public final class LogThroughActiveDialectEditorLogListener
implements ILogListener {
    public static final String SAVE_ALL_FAILED_MESSAGE = NLS.bind((String)WorkbenchMessages.EditorManager_operationFailed, (Object)WorkbenchMessages.SaveAll_text);
    public static final Function<Throwable, String> DEFAULT_ERROR_MESSAGE_PROVIDER = new ErrorMessageProvider();
    public static final LogThroughActiveDialectEditorLogListener INSTANCE = new LogThroughActiveDialectEditorLogListener();
    private Function<Throwable, String> errorMessageProvider = DEFAULT_ERROR_MESSAGE_PROVIDER;
    private SoftReference<Throwable> previousError;

    private LogThroughActiveDialectEditorLogListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logging(IStatus status, String plugin) {
        final Throwable exception = status != null && status.getException() != null ? Throwables.getRootCause((Throwable)status.getException()) : null;
        LogThroughActiveDialectEditorLogListener logThroughActiveDialectEditorLogListener = this;
        synchronized (logThroughActiveDialectEditorLogListener) {
            if (this.previousError != null && this.previousError.get() == exception) {
                return;
            }
            this.previousError = new SoftReference<Throwable>(exception);
        }
        boolean hasBeenLoggedThroughDialect = false;
        if (SiriusEditPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusUIPreferencesKeys.PREF_REACT_TO_PERMISSION_ISSUES_BY_GRAPHICAL_DISPLAY.name())) {
            String statusMessage;
            IEditorPart activeEditor;
            if (SiriusEditPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusUIPreferencesKeys.PREF_DISPLAY_PERMISSION_ISSUES_THROUGH_DIALOG.name()) && (activeEditor = EclipseUIUtil.getActiveEditor()) instanceof DialectEditor && this.shouldBeLoggedThroughDialect((DialectEditor)activeEditor, exception)) {
                ((DialectEditor)activeEditor).getDialogFactory().informUserOfEvent(4, this.errorMessageProvider.apply(exception));
                hasBeenLoggedThroughDialect = true;
            }
            String string = statusMessage = status != null ? status.getMessage() : "";
            if (!hasBeenLoggedThroughDialect && this.shouldBeLoggedThroughPopup(statusMessage, exception) && PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isStarting()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.LogThroughActiveDialectEditorLogListener_permissionError, (String)LogThroughActiveDialectEditorLogListener.this.errorMessageProvider.apply(exception));
                    }
                });
            }
        }
    }

    private boolean shouldBeLoggedThroughDialect(DialectEditor editor, Throwable exception) {
        if (exception instanceof LockedInstanceException) {
            EObject lockedElement = ((LockedInstanceException)exception).getLockedElement();
            final DRepresentation activeRepresentation = editor.getRepresentation();
            boolean isConcerningObjectsOfCurrentEditor = false;
            if (lockedElement != null && activeRepresentation != null) {
                Session session = null;
                session = lockedElement instanceof DSemanticDecorator ? SessionManager.INSTANCE.getSession(((DSemanticDecorator)lockedElement).getTarget()) : SessionManager.INSTANCE.getSession(lockedElement);
                Iterable representationsElementsReferencingLockedElement = Iterables.filter((Iterable)session.getSemanticCrossReferencer().getInverseReferences(lockedElement), (Predicate)new Predicate<EStructuralFeature.Setting>(){

                    public boolean apply(EStructuralFeature.Setting input) {
                        if (input.getEObject() instanceof DSemanticDecorator) {
                            DRepresentation concernedRepresentation = null;
                            if (input.getEObject() instanceof DRepresentation) {
                                concernedRepresentation = (DRepresentation)input.getEObject();
                            } else if (input.getEObject() instanceof DRepresentationElement) {
                                concernedRepresentation = new DRepresentationElementQuery((DRepresentationElement)input.getEObject()).getParentRepresentation();
                            }
                            return concernedRepresentation == activeRepresentation;
                        }
                        return false;
                    }
                });
                isConcerningObjectsOfCurrentEditor = representationsElementsReferencingLockedElement.iterator().hasNext();
            }
            return isConcerningObjectsOfCurrentEditor;
        }
        return false;
    }

    protected boolean shouldBeLoggedThroughPopup(String statusMessage, Throwable exception) {
        boolean shouldBeLogged = false;
        boolean bl = shouldBeLogged = exception instanceof LockedInstanceException && !SAVE_ALL_FAILED_MESSAGE.equals(statusMessage) || exception instanceof SecurityException;
        if (shouldBeLogged) {
            String message = this.errorMessageProvider.apply(exception);
            shouldBeLogged = !StringUtil.isEmpty((String)message);
        }
        return shouldBeLogged;
    }

    public void setErrorMessageProvider(Function<Throwable, String> errorMessageProvider) {
        if (errorMessageProvider == null) {
            throw new IllegalArgumentException(Messages.LogThroughActiveDialectEditorLogListener_wrongErrorMessageProvider);
        }
        this.errorMessageProvider = errorMessageProvider;
    }

    public void resetErrorMessageProvider() {
        this.errorMessageProvider = DEFAULT_ERROR_MESSAGE_PROVIDER;
    }
}

