/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.dialogs;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPVariable;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class VariableDialog
extends Dialog {
    protected IPStackFrame frame = null;
    protected ListViewer listViewer = null;
    protected IPVariable selectedVariable = null;

    public VariableDialog(Shell parent, IPStackFrame frame) {
        super(parent);
        this.frame = frame;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.VariableDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite result = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(770));
        new Label(result, 0).setText(Messages.VariableDialog_1);
        this.listViewer = new ListViewer(result, 2820);
        this.listViewer.getList().setLayoutData((Object)new GridData(1808));
        this.listViewer.getList().setFont(parent.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IVariable) {
                    try {
                        return ((IVariable)element).getName();
                    }
                    catch (DebugException e) {
                        return "";
                    }
                }
                return "";
            }
        });
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.listViewer.addFilter(this.getViewFilter());
        try {
            this.listViewer.setInput((Object)this.frame.getVariables());
        }
        catch (DebugException e) {
            this.listViewer.setInput(null);
        }
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VariableDialog.this.getOkButton().setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                VariableDialog.this.buttonPressed(0);
            }
        });
        VariableDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
    }

    protected abstract ViewerFilter getViewFilter();

    public Button getOkButton() {
        return this.getButton(0);
    }

    public IPVariable getSelectedVariable() {
        return this.selectedVariable;
    }

    protected void buttonPressed(int buttonId) {
        Object obj;
        ISelection selection;
        this.selectedVariable = null;
        if (buttonId == 0 && !(selection = this.listViewer.getSelection()).isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IPVariable) {
            this.selectedVariable = (IPVariable)obj;
        }
        super.buttonPressed(buttonId);
    }
}

