/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.CalculateUsesOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;

public class CalculateUsesAction
extends Action {
    private IProject fProject;
    private IBundlePluginModelBase fModel;

    public CalculateUsesAction(IProject project, IBundlePluginModelBase model) {
        this.fProject = project;
        this.fModel = model;
    }

    public void run() {
        Job job = this.createJob();
        job.setUser(true);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_PSEARCH_OBJ);
        job.schedule();
    }

    protected Job createJob() {
        return new WorkspaceJob(PDEUIMessages.CalculateUsesAction_jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                CalculateUsesOperation op = CalculateUsesAction.this.getOperation();
                try {
                    try {
                        op.run(monitor);
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
    }

    protected CalculateUsesOperation getOperation() {
        return new CalculateUsesOperation(this.fProject, this.fModel){

            @Override
            protected void handleSetUsesDirectives(Map<String, HashSet<String>> pkgsAndUses) {
                Display.getDefault().asyncExec(() -> {
                    if (pkgsAndUses.isEmpty()) {
                        return;
                    }
                    this.setUsesDirectives(pkgsAndUses);
                });
            }
        };
    }
}

