/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.util.MergeTraceAdapter;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

final class MergeTraces
extends AdapterImpl
implements MergeTraceAdapter {
    private final Multimap<ADElement, ADElement> traces = ArrayListMultimap.create();

    MergeTraces() {
    }

    public MergeTraces trace(ADElement mergedElement, ADElement sourceElement) {
        MergeTraces _xblockexpression = null;
        boolean _hasTraces = this.hasTraces(sourceElement);
        if (_hasTraces) {
            ArchitectureExtensions.logf("Tracing %s -> %s.", mergedElement, this.internalTrace(sourceElement));
            this.traces.putAll((Object)mergedElement, this.internalTrace(sourceElement));
        } else {
            ArchitectureExtensions.logf("Tracing %s -> %s.", mergedElement, sourceElement);
            this.traces.put((Object)mergedElement, (Object)sourceElement);
        }
        this.addAdapter((Notifier)mergedElement);
        _xblockexpression = this;
        return _xblockexpression;
    }

    private Collection<ADElement> internalTrace(ADElement mergedElement) {
        return this.traces.get((Object)mergedElement);
    }

    public boolean hasTraces(ADElement element) {
        boolean _isEmpty = this.internalTrace(element).isEmpty();
        return !_isEmpty;
    }

    public Collection<? extends ADElement> trace(ADElement mergedElement) {
        return Collections.unmodifiableCollection(this.internalTrace(mergedElement));
    }

    public boolean tracesTo(ADElement mergedElement, ADElement sourceElement) {
        return com.google.common.base.Objects.equal((Object)mergedElement, (Object)sourceElement) || this.internalTrace(mergedElement).contains(sourceElement);
    }

    public <T extends ADElement> T trace(final T mergedElement, final EStructuralFeature feature) {
        Functions.Function1<ADElement, Boolean> _function = new Functions.Function1<ADElement, Boolean>(){

            public Boolean apply(ADElement it) {
                return MergeTraces.this.intersects(feature, (EObject)mergedElement, (EObject)it);
            }
        };
        ADElement _findFirst = (ADElement)IterableExtensions.findFirst(this.internalTrace(mergedElement), (Functions.Function1)_function);
        return (T)_findFirst;
    }

    private boolean intersects(EStructuralFeature feature, EObject object1, EObject object2) {
        boolean _isSuperTypeOf;
        boolean _not;
        boolean _isMany;
        boolean _switchResult = false;
        boolean _matched = false;
        if (feature instanceof EAttribute) {
            _isMany = ((EAttribute)feature).isMany();
            boolean bl = _not = !_isMany;
            if (_not) {
                _matched = true;
                _switchResult = Objects.equals(object1.eGet(feature), object2.eGet(feature));
            }
        }
        if (!_matched && feature instanceof EAttribute) {
            _matched = true;
            Object _eGet = object1.eGet(feature);
            Object _eGet_1 = object2.eGet(feature);
            _switchResult = this.intersects((Collection)_eGet, (Collection)_eGet_1);
        }
        if (!_matched && feature instanceof EReference && ArchitecturePackage.Literals.AD_ELEMENT.isSuperTypeOf(((EReference)feature).getEReferenceType()) && !((EReference)feature).isMany()) {
            _matched = true;
            Object _eGet = object1.eGet(feature);
            Object _eGet_1 = object2.eGet(feature);
            _switchResult = this.tracesTo((ADElement)_eGet, (ADElement)_eGet_1);
        }
        if (!_matched && feature instanceof EReference && (_isSuperTypeOf = ArchitecturePackage.Literals.AD_ELEMENT.isSuperTypeOf(((EReference)feature).getEReferenceType()))) {
            _matched = true;
            Object _eGet = object1.eGet(feature);
            Object _eGet_1 = object2.eGet(feature);
            _switchResult = this.tracesAny((Collection)_eGet, (Collection)_eGet_1);
        }
        if (!_matched && feature instanceof EReference) {
            _isMany = ((EReference)feature).isMany();
            boolean bl = _not = !_isMany;
            if (_not) {
                Object _eGet_1;
                _matched = true;
                Object _eGet = object1.eGet(feature);
                boolean bl2 = _switchResult = _eGet == (_eGet_1 = object2.eGet(feature));
            }
        }
        if (!_matched) {
            Object _eGet = object1.eGet(feature);
            Object _eGet_1 = object2.eGet(feature);
            _switchResult = this.intersects((Collection)_eGet, (Collection)_eGet_1);
        }
        return _switchResult;
    }

    private boolean intersects(Collection<?> a, final Collection<?> b) {
        Functions.Function1<Object, Boolean> _function = new Functions.Function1<Object, Boolean>(){

            public Boolean apply(Object it) {
                return b.contains(it);
            }
        };
        return IterableExtensions.exists(a, (Functions.Function1)_function);
    }

    private boolean tracesAny(Collection<? extends ADElement> a, final Collection<? extends ADElement> b) {
        Functions.Function1<ADElement, Boolean> _function = new Functions.Function1<ADElement, Boolean>(){

            public Boolean apply(final ADElement fromA) {
                Functions.Function1<ADElement, Boolean> _function = new Functions.Function1<ADElement, Boolean>(){

                    public Boolean apply(ADElement fromB) {
                        return MergeTraces.this.tracesTo(fromA, fromB);
                    }
                };
                return IterableExtensions.exists((Iterable)b, (Functions.Function1)_function);
            }
        };
        return IterableExtensions.exists(a, (Functions.Function1)_function);
    }

    public boolean isAdapterForType(Object type) {
        return com.google.common.base.Objects.equal((Object)type, MergeTraceAdapter.class) || com.google.common.base.Objects.equal((Object)type, MergeTraces.class);
    }

    public boolean addAdapter(Notifier notifier) {
        boolean _not;
        boolean _xifexpression = false;
        boolean _contains = notifier.eAdapters().contains((Object)this);
        boolean bl = _not = !_contains;
        if (_not) {
            EList _eAdapters = notifier.eAdapters();
            _xifexpression = _eAdapters.add((Object)this);
        }
        return _xifexpression;
    }

    public boolean removeAdapter(Notifier notifier) {
        return notifier.eAdapters().remove((Object)this);
    }

    public void setTarget(Notifier newTarget) {
        boolean _matched = false;
        if (newTarget instanceof ADElement && com.google.common.base.Objects.equal((Object)newTarget, (Object)((ADElement)newTarget))) {
            _matched = true;
            Consumer<ADElement> _function = new Consumer<ADElement>(){

                @Override
                public void accept(ADElement it) {
                    MergeTraces.this.addAdapter((Notifier)it);
                }
            };
            Iterables.filter((Iterable)((ADElement)newTarget).eContents(), ADElement.class).forEach(_function);
        }
    }

    public void unsetTarget(Notifier oldTarget) {
        this.traces.removeAll((Object)oldTarget);
        boolean _matched = false;
        if (oldTarget instanceof ADElement && com.google.common.base.Objects.equal((Object)oldTarget, (Object)((ADElement)oldTarget))) {
            _matched = true;
            Consumer<ADElement> _function = new Consumer<ADElement>(){

                @Override
                public void accept(ADElement it) {
                    MergeTraces.this.removeAdapter((Notifier)it);
                }
            };
            Iterables.filter((Iterable)((ADElement)oldTarget).eContents(), ADElement.class).forEach(_function);
        }
    }

    public void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        boolean _matched = false;
        if (feature instanceof EReference && ArchitecturePackage.Literals.AD_ELEMENT.isSuperTypeOf(((EReference)feature).getEReferenceType()) && ((EReference)feature).isContainment()) {
            _matched = true;
            int _eventType = msg.getEventType();
            switch (_eventType) {
                case 3: {
                    Object _newValue = msg.getNewValue();
                    this.addAdapter((Notifier)((ADElement)_newValue));
                    break;
                }
                case 5: {
                    Object _newValue_1 = msg.getNewValue();
                    Consumer<ADElement> _function = new Consumer<ADElement>(){

                        @Override
                        public void accept(ADElement it) {
                            MergeTraces.this.addAdapter((Notifier)it);
                        }
                    };
                    ((Iterable)_newValue_1).forEach(_function);
                    break;
                }
                case 4: {
                    Object _oldValue = msg.getOldValue();
                    this.removeAdapter((Notifier)((ADElement)_oldValue));
                    break;
                }
                case 6: {
                    Object _oldValue_1 = msg.getOldValue();
                    Consumer<ADElement> _function_1 = new Consumer<ADElement>(){

                        @Override
                        public void accept(ADElement it) {
                            MergeTraces.this.removeAdapter((Notifier)it);
                        }
                    };
                    ((Iterable)_oldValue_1).forEach(_function_1);
                    break;
                }
                case 1: {
                    Object _newValue_2 = msg.getNewValue();
                    this.addAdapter((Notifier)((ADElement)_newValue_2));
                    Object _oldValue_2 = msg.getOldValue();
                    this.removeAdapter((Notifier)((ADElement)_oldValue_2));
                }
            }
        }
    }
}

