/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import java.net.URL;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;

public final class ExpandAllNodesAction
extends Action {
    private final @NonNull ValidityView validityView;
    private final boolean isValidatableExpandAction;
    private final boolean isConstrainingExpandAction;

    public ExpandAllNodesAction(@NonNull ValidityView validityView, boolean isValidatableExpandAction, boolean isConstrainingExpandAction) {
        super(ValidityUIMessages.ValidityView_Action_ExpandAllNodes_Title);
        this.validityView = validityView;
        this.isValidatableExpandAction = isValidatableExpandAction;
        this.isConstrainingExpandAction = isConstrainingExpandAction;
        if (isValidatableExpandAction && isConstrainingExpandAction) {
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_ExpandAllNodes_ToolTipText);
        } else if (isValidatableExpandAction) {
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_ExpandAllValidatableNodes_ToolTipText);
        } else if (isConstrainingExpandAction) {
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_ExpandAllConstrainingNodes_ToolTipText);
        }
        URL image = (URL)ValidityUIPlugin.INSTANCE.getImage(ValidityUIMessages.ValidityView_Action_ExpandAllNodes_ImageLocation);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)image));
    }

    public void run() {
        RootNode rootNode = this.validityView.getValidityManager().getRootNode();
        if (rootNode != null) {
            if (this.isValidatableExpandAction) {
                this.validityView.getValidatableNodesViewer().expandAll();
            }
            if (this.isConstrainingExpandAction) {
                this.validityView.getConstrainingNodesViewer().expandAll();
            }
        }
    }
}

