/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import org.eclipse.dltk.dbgp.internal.packets.DbgpPacketWaiter;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponcePacketWaiter;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlPacketParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbgpPackageProcessor {
    private static final String INIT_TAG = "init";
    private static final String RESPONSE_TAG = "response";
    private static final String STREAM_TAG = "stream";
    private static final String NOTIFY_TAG = "notify";

    public void processPacket(Document doc, DbgpPacketWaiter notifyWaiter, DbgpResponcePacketWaiter responseWaiter, DbgpPacketWaiter streamWaiter) {
        Element element = (Element)doc.getFirstChild();
        String tag = element.getTagName();
        if (tag.equals(INIT_TAG)) {
            responseWaiter.put(new DbgpResponsePacket(element, -1));
        } else if (tag.equals(RESPONSE_TAG)) {
            DbgpResponsePacket packet = DbgpXmlPacketParser.parseResponsePacket(element);
            responseWaiter.put(packet);
        } else if (tag.equals(STREAM_TAG)) {
            streamWaiter.put(DbgpXmlPacketParser.parseStreamPacket(element));
        } else if (tag.equals(NOTIFY_TAG)) {
            notifyWaiter.put(DbgpXmlPacketParser.parseNotifyPacket(element));
        }
    }
}

