/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile.internal;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.oda.util.manifest.ConnectionProfileProperty;

public class OdaProfileFactory {
    private static final String NAME_SEPARATOR = " ";
    private static final String sm_className = OdaProfileFactory.class.getName();
    private static Logger sm_logger;

    public static IConnectionProfile createProfile(String name, String description, String odaDataSourceId, Properties profileProperties) throws OdaException {
        String uniqueName = OdaProfileFactory.getUniqueProfileName(name);
        String profileProviderId = profileProperties.getProperty("org.eclipse.datatools.connectivity.oda.profile.db.provider.id");
        if (profileProviderId != null) {
            odaDataSourceId = profileProviderId;
        }
        try {
            IConnectionProfile newProfile = ProfileManager.getInstance().createProfile(uniqueName, description, odaDataSourceId, profileProperties);
            return new OdaConnectionProfile(newProfile);
        }
        catch (ConnectionProfileException ex) {
            OdaProfileFactory.getLogger().logp(Level.WARNING, sm_className, "createProfile(String,String,String,Properties)", "Unable to create a persistent profile instance.", ex);
            throw new OdaException((Throwable)ex);
        }
    }

    public static IConnectionProfile createTransientProfile(Properties connProperties) throws OdaException {
        String profileProviderId;
        if (ConnectionProfileProperty.hasProfileName((Properties)connProperties)) {
            OdaProfileFactory.getLogger().logp(Level.FINE, sm_className, "createTransientProfile(Properties)", "The connection properties contain an external profile name reference; not expected to use for a transient profile.");
            return null;
        }
        String string = profileProviderId = connProperties != null ? connProperties.getProperty("org.eclipse.datatools.connectivity.oda.profile.db.provider.id") : null;
        if (profileProviderId == null || profileProviderId.length() == 0) {
            OdaProfileFactory.getLogger().logp(Level.FINE, sm_className, "createTransientProfile(Properties)", "No profile provider id specified in the connection properties.");
            return null;
        }
        return OdaProfileFactory.createTransientProfile(profileProviderId, connProperties);
    }

    public static IConnectionProfile createTransientProfile(String odaDataSourceId, Properties profileProperties) throws OdaException {
        try {
            IConnectionProfile newProfile = ProfileManager.getInstance().createTransientProfile(odaDataSourceId, profileProperties);
            return new OdaConnectionProfile(newProfile);
        }
        catch (ConnectionProfileException ex) {
            OdaProfileFactory.getLogger().logp(Level.WARNING, sm_className, "createTransientProfile(String,Properties)", "Unable to create a transient profile instance.", ex);
            throw new OdaException((Throwable)ex);
        }
    }

    public static boolean isProfileNameUsed(String profileName) {
        IConnectionProfile existingProfile = InternalProfileManager.getInstance().getProfileByName(profileName, false);
        return existingProfile != null;
    }

    private static String getUniqueProfileName(String profileName) {
        if (!OdaProfileFactory.isProfileNameUsed(profileName)) {
            return profileName;
        }
        int nameCounter = 1;
        String newName = OdaProfileFactory.formatProfileName(profileName, nameCounter);
        while (OdaProfileFactory.isProfileNameUsed(newName)) {
            newName = OdaProfileFactory.formatProfileName(profileName, ++nameCounter);
        }
        return newName;
    }

    private static String formatProfileName(String profileName, int nameCounter) {
        return String.valueOf(profileName) + NAME_SEPARATOR + nameCounter;
    }

    public static File defaultProfileStoreFile() {
        return ConnectionProfileMgmt.getStorageLocation().append("ServerProfiles.dat").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<OdaProfileFactory> clazz = OdaProfileFactory.class;
        synchronized (OdaProfileFactory.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = Logger.getLogger(sm_className);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }
}

