/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.transport;

import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.apache.soap.Body;
import org.apache.soap.Envelope;
import org.apache.soap.messaging.Message;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.xml.DOMWriter;
import org.uddi4j.transport.TransportBase;
import org.uddi4j.transport.TransportException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApacheSOAPTransport
extends TransportBase {
    private boolean debug = false;
    private SOAPHTTPConnection connection;

    public Element send(Element el, URL url) throws TransportException {
        this.debug = this.logEnabled();
        if (this.connection == null) {
            this.setConnection();
        }
        Envelope sendEnv = new Envelope();
        Body sendBody = new Body();
        Vector<Element> bodyEntry = new Vector<Element>();
        bodyEntry.add(el);
        sendBody.setBodyEntries(bodyEntry);
        sendEnv.setBody(sendBody);
        Message soapMessage = new Message();
        soapMessage.setSOAPTransport((SOAPTransport)this.connection);
        Element base = null;
        try {
            if (this.debug) {
                System.err.println("\nRequest body:\n" + DOMWriter.nodeToString((Node)el));
            }
            soapMessage.send(url, "", sendEnv);
            Envelope responseEnv = soapMessage.receiveEnvelope();
            Body responseBody = responseEnv.getBody();
            base = (Element)responseBody.getBodyEntries().firstElement();
            if (this.debug) {
                System.err.println("\nResponse body:\n" + DOMWriter.nodeToString((Node)base));
            }
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
        return base;
    }

    private void setConnection() {
        this.connection = new SOAPHTTPConnection();
        Properties config = this.getConfiguration();
        this.connection = new SOAPHTTPConnection();
        this.connection.setUserName(config.getProperty("http.basicAuthUserName"));
        this.connection.setPassword(config.getProperty("http.basicAuthPassword"));
        this.connection.setProxyHost(config.getProperty("http.proxyHost"));
        this.connection.setProxyUserName(config.getProperty("http.basicAuthUserName"));
        this.connection.setProxyPassword(config.getProperty("http.proxyPassword"));
        try {
            int proxyPort = Integer.parseInt(config.getProperty("http.proxyPort"));
            this.connection.setProxyPort(proxyPort);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

