/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.SourceNameMapperContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.VProjectSourceContainer;

public class ChromiumSourceComputer
implements ISourcePathComputerDelegate {
    private static final String SEPARATOR = System.getProperty("file.separator");

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        Path resourcePath;
        IResource resource;
        IProject project;
        ArrayList<Object> containers = new ArrayList<Object>();
        String projectName = configuration.getAttribute("attr_app_project", null);
        String path = configuration.getAttribute("attr_app_project_relative_path", null);
        String remoteDir = configuration.getAttribute("attr_remote_home dir", null);
        String baseURL = configuration.getAttribute("attr_base_url", null);
        if (projectName != null && path != null && (project = this.getProject(projectName)) != null && project.isAccessible() && (resource = project.findMember((IPath)(resourcePath = new Path(path)))).isAccessible()) {
            IContainer container = this.getContainerForMapping(resource);
            String containerMapping = remoteDir != null ? remoteDir : (baseURL != null ? this.normalizeURL(baseURL) : container.getLocation().toOSString());
            SourceNameMapperContainer workspaceConatiner = this.createWorkspaceSourceContainer(container, containerMapping);
            containers.add(workspaceConatiner);
        }
        containers.add(new VProjectSourceContainer());
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    private IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private IContainer getContainerForMapping(IResource resource) {
        IContainer container = null;
        if (resource instanceof IFile) {
            container = resource.getParent();
        } else if (resource instanceof IContainer) {
            container = (IContainer)resource;
        }
        return container;
    }

    private SourceNameMapperContainer createWorkspaceSourceContainer(IContainer container, String containerMapping) {
        ProjectSourceContainer sourceContainer = null;
        if (container instanceof IProject) {
            sourceContainer = new ProjectSourceContainer((IProject)container, true);
        } else if (container instanceof IFolder) {
            sourceContainer = new FolderSourceContainer((IContainer)((IFolder)container), true);
        }
        return new SourceNameMapperContainer(this.normalizeMapping(containerMapping), (ISourceContainer)sourceContainer);
    }

    private String normalizeMapping(String containerMapping) {
        String normalizedMapping = null;
        normalizedMapping = containerMapping.endsWith("/") || containerMapping.endsWith("\\") ? containerMapping : (containerMapping.startsWith("file") || containerMapping.startsWith("http") || containerMapping.startsWith("/") ? String.valueOf(containerMapping) + "/" : String.valueOf(containerMapping) + SEPARATOR);
        return normalizedMapping;
    }

    private String normalizeURL(String url) {
        if (url.startsWith("file:") && !url.startsWith("file://")) {
            return url.replaceFirst("file:", "file://");
        }
        return url;
    }
}

