/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectConfig;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelPreferences;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;

public class TmfProjectElement
extends TmfProjectModelElement {
    static final String TRACECOMPASS_PROJECT_FILE = ".tracecompass";
    private @Nullable TmfTraceFolder fTraceFolder = null;
    private @Nullable TmfExperimentFolder fExperimentFolder = null;
    private @Nullable IFolder fSupplFolder = null;

    public TmfProjectElement(String name, IProject project, ITmfProjectModelElement parent) {
        super(name, (IResource)project, parent);
    }

    public IProject getResource() {
        return (IProject)super.getResource();
    }

    @Override
    public void addChild(ITmfProjectModelElement child) {
        super.addChild(child);
        if (child instanceof TmfTraceFolder) {
            this.fTraceFolder = (TmfTraceFolder)child;
            return;
        }
        if (child instanceof TmfExperimentFolder) {
            this.fExperimentFolder = (TmfExperimentFolder)child;
            return;
        }
    }

    public @Nullable TmfTraceFolder getTracesFolder() {
        return this.fTraceFolder;
    }

    public @Nullable TmfExperimentFolder getExperimentsFolder() {
        return this.fExperimentFolder;
    }

    public IFolder getSupplementaryFolder() {
        return this.fSupplFolder;
    }

    @Override
    protected synchronized void refreshChildren() {
        ITmfProjectModelElement element;
        String name;
        IProject project = this.getResource();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element2 : this.getChildren()) {
            childrenMap.put(element2.getResource().getName(), element2);
        }
        TmfProjectConfig config = TmfProjectElement.getFolderStructure(project);
        IFolder folder = config.getTracesFolder();
        if (folder != null && folder.exists()) {
            name = folder.getName();
            element = (ITmfProjectModelElement)childrenMap.get(name);
            if (element instanceof TmfTracesFolder) {
                childrenMap.remove(name);
            } else {
                element = new TmfTracesFolder("Traces", folder, this);
                this.addChild(element);
            }
            ((TmfTracesFolder)element).refreshChildren();
        }
        if ((folder = config.getExperimentsFolder()) != null && folder.exists()) {
            name = folder.getName();
            element = (ITmfProjectModelElement)childrenMap.get(name);
            if (element instanceof TmfExperimentFolder) {
                childrenMap.remove(name);
            } else {
                element = new TmfExperimentFolder("Experiments", folder, this);
                this.addChild(element);
            }
            ((TmfExperimentFolder)element).refreshChildren();
        }
        this.fSupplFolder = config.getSupplementaryFolder();
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
    }

    @Override
    public TmfProjectElement getProject() {
        return this;
    }

    @Override
    public Image getIcon() {
        return TmfProjectModelPreferences.getProjectModelIcon();
    }

    @Override
    public String getLabelText() {
        return TmfProjectModelPreferences.getProjectModelLabel();
    }

    static void createFolderStructure(IContainer parent) throws CoreException {
        IFolder folder = parent.getFolder((IPath)new Path("Traces"));
        TmfProjectElement.createFolder(folder);
        folder = parent.getFolder((IPath)new Path("Experiments"));
        TmfProjectElement.createFolder(folder);
        folder = parent.getFolder((IPath)new Path(".tracing"));
        TmfProjectElement.createFolder(folder);
    }

    static IFolder createFolderStructure(IProject project, IProject shadowProject) throws CoreException {
        if (shadowProject != null) {
            TmfProjectElement.createFolderStructure((IContainer)shadowProject);
        }
        IFolder parentFolder = project.getFolder(TRACECOMPASS_PROJECT_FILE);
        TmfProjectElement.createFolder(parentFolder);
        return parentFolder;
    }

    static TmfProjectConfig getFolderStructure(IProject project) {
        TmfProjectConfig.Builder builder = new TmfProjectConfig.Builder();
        IFolder folder = project.getFolder((IPath)new Path("Traces"));
        builder.setTracesFolder(folder);
        folder = project.getFolder((IPath)new Path("Experiments"));
        builder.setExperimentsFolder(folder);
        folder = project.getFolder((IPath)new Path(".tracing"));
        builder.setSupplementaryFolder(folder);
        return builder.build();
    }

    private static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
    }

    static boolean showProjectRoot(IProject project) {
        IFolder traceCompassFile = project.getFolder(TRACECOMPASS_PROJECT_FILE);
        return traceCompassFile != null && traceCompassFile.exists();
    }
}

