/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.condition;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;

public class ConsoleHasNoChange
extends AbstractWaitCondition {
    private TimePeriod timePeriod;
    private String consoleText;
    private long consoleTime;

    public ConsoleHasNoChange() {
        this(TimePeriod.DEFAULT);
    }

    public ConsoleHasNoChange(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        this.consoleText = ConsoleHasNoChange.getConsoleText();
        this.consoleTime = System.currentTimeMillis();
    }

    public boolean test() {
        String currentConsoleText = ConsoleHasNoChange.getConsoleText();
        long currentConsoleTime = System.currentTimeMillis();
        if (!currentConsoleText.equals(this.consoleText)) {
            this.consoleText = currentConsoleText;
            this.consoleTime = currentConsoleTime;
            return false;
        }
        return currentConsoleTime - this.consoleTime - this.timePeriod.getSeconds() * 1000L >= 0L;
    }

    public String description() {
        return "Console is still changing";
    }

    private static String getConsoleText() {
        ConsoleView consoleView = new ConsoleView();
        consoleView.open();
        return consoleView.getConsoleText();
    }
}

